/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.rfc6749;

import java.math.BigInteger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.authz.oauth2.rfc6749.AbstractRFC6749Test;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class Section440ClientCredentialsTest
extends AbstractRFC6749Test {
    private static ApplicationBuilder.ApplicationContext context;
    private static ApplicationBuilder.ApplicationContext authContext;
    private static String authHeader;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    @Test
    public void testTokenSimpleRequest() {
        Client c = authContext.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("client_secret", c.getClientSecret());
        f.param("grant_type", "client_credentials");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testBadPassword() {
        Client c = authContext.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("client_secret", "invalid_secret");
        f.param("grant_type", "client_credentials");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenNoClientId() {
        Form f = new Form();
        f.param("grant_type", "client_credentials");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenNoGrant() {
        Client c = authContext.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("client_secret", c.getClientSecret());
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenAuthHeaderValid() {
        Client c = authContext.getClient();
        Form f = new Form();
        f.param("grant_type", "client_credentials");
        f.param("scope", "debug");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
        Assert.assertEquals((Object)"debug", (Object)entity.getScope());
    }

    @Test
    public void testTokenAuthHeaderMismatchClientId() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("grant_type", "client_credentials");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenAuthHeaderValidNoExplicitClientId() {
        Form f = new Form();
        f.param("grant_type", "client_credentials");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
    }

    @Test
    public void testTokenAuthHeaderInvalid() {
        Client c = authContext.getClient();
        String authHeader = HttpUtil.authHeaderBasic((BigInteger)c.getId(), (String)"badsecret");
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("grant_type", "client_credentials");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenAuthBothMethods() {
        Client c = authContext.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("client_secret", c.getClientSecret());
        f.param("grant_type", "client_credentials");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
    }

    @Test
    public void testTokenInvalidGrantTypePassword() {
        Client c = authContext.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("client_secret", c.getClientSecret());
        f.param("grant_type", "password");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenInvalidGrantTypeRefreshToken() {
        Client c = authContext.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("client_secret", c.getClientSecret());
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenUnknownGrantType() {
        Client c = authContext.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("client_secret", c.getClientSecret());
        f.param("grant_type", "unknown_grant_type");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).scope("debug").client(ClientType.ClientCredentials, false).build();
                authContext = ApplicationBuilder.newApplication(session).scope("debug").client(ClientType.ClientCredentials, true).build();
                authHeader = HttpUtil.authHeaderBasic((BigInteger)authContext.getClient().getId(), (String)authContext.getClient().getClientSecret());
            }
        };
    }
}

