/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.rfc6749;

import java.math.BigInteger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.authz.oauth2.rfc6749.AbstractRFC6749Test;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class Section430OwnerPasswordTest
extends AbstractRFC6749Test {
    private static String username = "valid_user";
    private static String password = "valid_password";
    private static ApplicationBuilder.ApplicationContext builder;
    private static ApplicationBuilder.ApplicationContext authBuilder;
    private static String authHeader;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    @Test
    public void testTokenSimpleRequest() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)builder.getClient().getId()));
        f.param("grant_type", "password");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testTokenBadAuth() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)builder.getClient().getId()));
        f.param("grant_type", "password");
        f.param("username", username);
        f.param("password", "wrong_password");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"unauthorized", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenNoClientId() {
        Form f = new Form();
        f.param("grant_type", "password");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenNoGrant() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)builder.getClient().getId()));
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenAuthHeaderValid() {
        Form f = new Form();
        f.param("grant_type", "password");
        f.param("scope", "debug");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
        Assert.assertEquals((Object)"debug", (Object)entity.getScope());
    }

    @Test
    public void testTokenAuthHeaderMismatchClientId() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)builder.getClient().getId()));
        f.param("grant_type", "password");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenAuthHeaderValidNoExplicitClientId() {
        Form f = new Form();
        f.param("grant_type", "password");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
    }

    @Test
    public void testTokenAuthHeaderInvalid() {
        String badHeader = HttpUtil.authHeaderBasic((BigInteger)authBuilder.getClient().getId(), (String)"badsecret");
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)authBuilder.getClient().getId()));
        f.param("grant_type", "password");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)badHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenAuthSecretInBody() {
        Client c = authBuilder.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("client_secret", c.getClientSecret());
        f.param("grant_type", "password");
        f.param("scope", "debug");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
        Assert.assertEquals((Object)"debug", (Object)entity.getScope());
    }

    @Test
    public void testTokenAuthBothMethods() {
        Client c = authBuilder.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("client_secret", c.getClientSecret());
        f.param("grant_type", "password");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
    }

    @Test
    public void testTokenInvalidGrantTypeRefreshToken() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)builder.getClient().getId()));
        f.param("grant_type", "refresh_token");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenInvalidGrantTypeClientCredentials() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)builder.getClient().getId()));
        f.param("grant_type", "client_credentials");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenUnknownGrantType() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)builder.getClient().getId()));
        f.param("grant_type", "unknown_grant_type");
        f.param("username", username);
        f.param("password", password);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                builder = ApplicationBuilder.newApplication(session).scope("debug").role("debug", new String[]{"debug"}).client(ClientType.OwnerCredentials).authenticator(AuthenticatorType.Password).user().login(username, password).build();
                authBuilder = ApplicationBuilder.newApplication(session).scope("debug").role("debug", new String[]{"debug"}).client(ClientType.OwnerCredentials, true).authenticator(AuthenticatorType.Password).user().login(username, password).build();
                authHeader = HttpUtil.authHeaderBasic((BigInteger)authBuilder.getClient().getId(), (String)authBuilder.getClient().getClientSecret());
            }
        };
    }
}

