/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.rfc6749;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.HttpSession;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.rfc6749.AbstractRFC6749Test;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class Section420ImplicitGrantTest
extends AbstractRFC6749Test {
    private static ApplicationBuilder.ApplicationContext context;
    private static ApplicationBuilder.ApplicationContext twoRedirectContext;
    private static ApplicationBuilder.ApplicationContext noRoleContext;
    private static ApplicationBuilder.ApplicationContext roleNoScopeContext;
    private static ApplicationBuilder.ApplicationContext bareContext;
    private static ApplicationBuilder.ApplicationContext noauthContext;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    private HttpSession assertNewSession(Response r) {
        Map cookies = r.getCookies();
        Assert.assertTrue((boolean)cookies.containsKey("kangaroo"));
        NewCookie kangarooCookie = (NewCookie)cookies.get("kangaroo");
        BigInteger sessionId = IdUtil.fromString((String)kangarooCookie.getValue());
        Session hSession = this.getSession();
        hSession.beginTransaction();
        HttpSession dbSession = (HttpSession)hSession.get(HttpSession.class, (Serializable)sessionId);
        hSession.getTransaction().commit();
        Assert.assertNotNull((Object)dbSession);
        Assert.assertTrue((boolean)kangarooCookie.isHttpOnly());
        Assert.assertTrue((boolean)kangarooCookie.isSecure());
        Assert.assertTrue((kangarooCookie.getExpiry().compareTo(new Date()) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"localhost", (Object)kangarooCookie.getDomain());
        return dbSession;
    }

    private void assertRotatedSession(Response first, Response second) {
        NewCookie firstCookie = (NewCookie)first.getCookies().get("kangaroo");
        NewCookie secondCookie = (NewCookie)second.getCookies().get("kangaroo");
        Assert.assertEquals((long)firstCookie.getMaxAge(), (long)secondCookie.getMaxAge());
        Assert.assertEquals((Object)firstCookie.getDomain(), (Object)secondCookie.getDomain());
        Assert.assertEquals((Object)firstCookie.getName(), (Object)secondCookie.getName());
        Assert.assertEquals((Object)firstCookie.getPath(), (Object)secondCookie.getPath());
        Assert.assertNotEquals((Object)firstCookie.getValue(), (Object)secondCookie.getValue());
        BigInteger firstCookieId = IdUtil.fromString((String)firstCookie.getValue());
        BigInteger secondCookieId = IdUtil.fromString((String)secondCookie.getValue());
        Session hSession = this.getSession();
        hSession.clear();
        hSession.beginTransaction();
        HttpSession firstDbSession = (HttpSession)hSession.get(HttpSession.class, (Serializable)firstCookieId);
        HttpSession secondDbSession = (HttpSession)hSession.get(HttpSession.class, (Serializable)secondCookieId);
        hSession.getTransaction().commit();
        Assert.assertNull((Object)firstDbSession);
        Assert.assertNotNull((Object)secondDbSession);
    }

    private void assertNoNewSession(Response first) {
        Assert.assertNull(first.getCookies().get("kangaroo"));
    }

    private void assertValidSessionRefreshToken(MultivaluedMap<String, String> params) {
        String token = (String)params.getFirst((Object)"access_token");
        BigInteger tokenId = IdUtil.fromString((String)token);
        OAuthToken bearerToken = (OAuthToken)this.getSession().get(OAuthToken.class, (Serializable)tokenId);
        Assert.assertNotNull((Object)bearerToken);
        Assert.assertTrue((boolean)bearerToken.getTokenType().equals((Object)OAuthTokenType.Bearer));
        OAuthToken refreshToken = (OAuthToken)this.getSession().createCriteria(OAuthToken.class).add((Criterion)Restrictions.eq((String)"authToken", (Object)bearerToken)).uniqueResult();
        Assert.assertNotNull((Object)refreshToken);
        Assert.assertTrue((boolean)refreshToken.getTokenType().equals((Object)OAuthTokenType.Refresh));
    }

    @Test
    public void testAuthorizeSimpleRequest() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).request().get();
        this.assertNewSession(first);
        Response second = this.followRedirect(first);
        this.assertRotatedSession(first, second);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
    }

    @Test
    public void testAuthorizeResponseTypeInvalid() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"invalid"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"unsupported_response_type", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testAuthorizeClientIdMalformed() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{"invalid_client_id"}).request().get();
        this.assertNoNewSession(first);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)first.getStatus());
        Assert.assertNull((Object)first.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)first.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)first.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"bad_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeClientIdInvalid() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)IdUtil.next())}).request().get();
        this.assertNoNewSession(first);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)first.getStatus());
        Assert.assertNull((Object)first.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)first.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)first.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeScopeSimple() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).request().get();
        this.assertNewSession(first);
        Response second = this.followRedirect(first);
        this.assertNewSession(second);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertEquals((Object)"debug", (Object)params.getFirst((Object)"scope"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeNone() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)noauthContext.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"invalid_request", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testAuthorizeScopeInvalid() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("scope", new Object[]{"invalid"}).request().get();
        this.assertNewSession(first);
        Response second = this.followRedirect(first);
        this.assertRotatedSession(first, second);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeStateSimple() {
        String state = IdUtil.toString((BigInteger)IdUtil.next());
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).queryParam("state", new Object[]{state}).request().get();
        this.assertNewSession(first);
        Response second = this.followRedirect(first);
        this.assertRotatedSession(first, second);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertEquals((Object)"debug", (Object)params.getFirst((Object)"scope"));
        Assert.assertEquals((Object)state, (Object)params.getFirst((Object)"state"));
    }

    @Test
    public void testAuthorizeRedirectSimple() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("scope", new Object[]{"debug"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://valid.example.com/redirect"}).request().get();
        this.assertNewSession(first);
        Response second = this.followRedirect(first);
        this.assertRotatedSession(first, second);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertEquals((Object)"debug", (Object)params.getFirst((Object)"scope"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeRedirectMulti() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)twoRedirectContext.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://other.example.com/redirect"}).request().get();
        this.assertNewSession(first);
        Response second = this.followRedirect(first);
        this.assertRotatedSession(first, second);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"other.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeRedirectNoneRegistered() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)bareContext.getClient().getId())}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)first.getStatus());
        Assert.assertNull((Object)first.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)first.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)first.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeRedirectNoneRegisteredWithRequest() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)bareContext.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://redirect.example.com/redirect"}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)first.getStatus());
        Assert.assertNull((Object)first.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)first.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)first.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeRedirectMultiNoneProvided() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)twoRedirectContext.getClient().getId())}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)first.getStatus());
        Assert.assertNull((Object)first.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)first.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)first.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeRedirectDefault() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI firstLocation = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)firstLocation.getScheme());
        Assert.assertEquals((Object)"localhost", (Object)firstLocation.getHost());
        Assert.assertEquals((Object)"/authorize/callback", (Object)firstLocation.getPath());
        Response second = this.followRedirect(first);
        this.assertRotatedSession(first, second);
        URI secondLocation = second.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((String)secondLocation.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeRedirectInvalid() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://invalid.example.com/redirect"}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)first.getStatus());
        Assert.assertNull((Object)first.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)first.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)first.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeRedirectNoRole() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)noRoleContext.getClient().getId())}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI firstLocation = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)firstLocation.getScheme());
        Assert.assertEquals((Object)"localhost", (Object)firstLocation.getHost());
        Assert.assertEquals((Object)"/authorize/callback", (Object)firstLocation.getPath());
        Response second = this.followRedirect(first);
        this.assertNoNewSession(second);
        URI secondLocation = second.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((String)secondLocation.getFragment());
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"invalid_scope", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testAuthorizeRedirectRoleWithoutRequestedScope() {
        ApplicationBuilder.ApplicationContext testContext = bareContext.getBuilder().scope("debug").redirect("http://valid.example.com/redirect").role("test", new String[0]).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("scope", new Object[]{"debug"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)testContext.getClient().getId())}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI firstLocation = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)firstLocation.getScheme());
        Assert.assertEquals((Object)"localhost", (Object)firstLocation.getHost());
        Assert.assertEquals((Object)"/authorize/callback", (Object)firstLocation.getPath());
        Response second = this.followRedirect(first);
        this.assertNoNewSession(second);
        URI secondLocation = second.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((String)secondLocation.getFragment());
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"invalid_scope", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testAuthorizeRedirectRoleWantsNoScope() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)roleNoScopeContext.getClient().getId())}).request().get();
        this.assertNewSession(first);
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI firstLocation = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)firstLocation.getScheme());
        Assert.assertEquals((Object)"localhost", (Object)firstLocation.getHost());
        Assert.assertEquals((Object)"/authorize/callback", (Object)firstLocation.getPath());
        Response second = this.followRedirect(first);
        this.assertRotatedSession(first, second);
        URI secondLocation = second.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((String)secondLocation.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testRefreshSimpleRequest() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().bearerToken().refreshToken().httpSession(false).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)refreshContext.getClient().getId())}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        this.assertNewSession(first);
        Assert.assertNull((Object)this.getSession().get(HttpSession.class, (Serializable)refreshContext.getHttpSession().getId()));
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
    }

    @Test
    public void testRefreshSimpleRequestWithoutBearer() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().refreshToken().httpSession(false).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)refreshContext.getClient().getId())}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        this.assertNewSession(first);
        Assert.assertNull((Object)this.getSession().get(HttpSession.class, (Serializable)refreshContext.getHttpSession().getId()));
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
    }

    @Test
    public void testRefreshResponseTypeInvalid() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().bearerToken().refreshToken().httpSession(false).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"invalid"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)refreshContext.getClient().getId())}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        Assert.assertNotNull((Object)this.getSession().get(HttpSession.class, (Serializable)refreshContext.getHttpSession().getId()));
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"unsupported_response_type", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testRefreshClientIdMalformed() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().bearerToken().refreshToken().httpSession(false).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{"malformed_client_id"}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)first.getStatus());
        Assert.assertNull((Object)first.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)first.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)first.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"bad_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testRefreshScopeSimple() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().bearerToken("debug").refreshToken().httpSession(false).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)refreshContext.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        this.assertNewSession(first);
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertEquals((Object)"debug", (Object)params.getFirst((Object)"scope"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testRefreshScopeInvalid() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().bearerToken("debug").refreshToken().httpSession(false).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)refreshContext.getClient().getId())}).queryParam("scope", new Object[]{"invalid"}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testRefreshStateSimple() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().bearerToken("debug").refreshToken().httpSession(false).build();
        String state = IdUtil.toString((BigInteger)IdUtil.next());
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)refreshContext.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).queryParam("state", new Object[]{state}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        this.assertNewSession(first);
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertEquals((Object)"debug", (Object)params.getFirst((Object)"scope"));
        Assert.assertEquals((Object)state, (Object)params.getFirst((Object)"state"));
    }

    @Test
    public void testRefreshRedirectSimple() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().token(OAuthTokenType.Bearer, false, "debug", "http://valid.example.com/redirect", null).refreshToken().httpSession(false).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("scope", new Object[]{"debug"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)refreshContext.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://valid.example.com/redirect"}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        this.assertNewSession(first);
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertEquals((Object)"debug", (Object)params.getFirst((Object)"scope"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testRefreshClientIsolation() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().bearerToken().refreshToken().httpSession(false).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)roleNoScopeContext.getClient().getId())}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        this.assertNewSession(first);
        Response second = this.followRedirect(first);
        this.assertRotatedSession(first, second);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        this.assertValidBearerToken((MultivaluedMap<String, String>)params, true);
        this.assertValidSessionRefreshToken((MultivaluedMap<String, String>)params);
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
    }

    @Test
    public void testRefreshWithExpiredToken() {
        ApplicationBuilder.ApplicationContext refreshContext = context.getBuilder().user().identity().bearerToken("debug").build();
        OAuthToken original = refreshContext.getToken();
        refreshContext = refreshContext.getBuilder().token(OAuthTokenType.Refresh, true, null, null, original).httpSession(false).build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)refreshContext.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"localhost", (Object)location.getHost());
        Assert.assertEquals((Object)"/authorize/callback", (Object)location.getPath());
    }

    @Test
    public void testRefreshWithTooManyTokens() {
        ApplicationBuilder refreshBuilder = context.getBuilder().user().identity().bearerToken("debug").refreshToken().httpSession(false).refreshToken();
        refreshBuilder.getContext().getToken().setHttpSession(refreshBuilder.getContext().getHttpSession());
        ApplicationBuilder.ApplicationContext refreshContext = refreshBuilder.build();
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"token"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)refreshContext.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).request().cookie("kangaroo", refreshContext.getHttpSessionId()).get();
        URI location = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"localhost", (Object)location.getHost());
        Assert.assertEquals((Object)"/authorize/callback", (Object)location.getPath());
        Session s = this.getSession();
        s.beginTransaction();
        Assert.assertNull((Object)s.get(OAuthToken.class, (Serializable)refreshContext.getToken().getId()));
        s.getTransaction().commit();
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).scope("debug").role("test", new String[]{"debug"}).client(ClientType.Implicit).authenticator(AuthenticatorType.Test).redirect("http://valid.example.com/redirect").build();
                twoRedirectContext = ApplicationBuilder.newApplication(session).scope("debug").role("test", new String[]{"debug"}).client(ClientType.Implicit).authenticator(AuthenticatorType.Test).redirect("http://valid.example.com/redirect").redirect("http://other.example.com/redirect").build();
                bareContext = ApplicationBuilder.newApplication(session).client(ClientType.Implicit).authenticator(AuthenticatorType.Test).build();
                noRoleContext = ApplicationBuilder.newApplication(session).client(ClientType.Implicit).authenticator(AuthenticatorType.Test).redirect("http://valid.example.com/redirect").build();
                roleNoScopeContext = ApplicationBuilder.newApplication(session).client(ClientType.Implicit).authenticator(AuthenticatorType.Test).scope("debug").redirect("http://valid.example.com/redirect").role("test", new String[0]).build();
                noauthContext = ApplicationBuilder.newApplication(session).scope("debug").role("test", new String[]{"debug"}).client(ClientType.Implicit).redirect("http://valid.example.com/redirect").build();
            }
        };
    }
}

