/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.rfc6749;

import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.authz.oauth2.rfc6749.AbstractRFC6749Test;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class Section410AuthorizationCodeGrantTest
extends AbstractRFC6749Test {
    private static ApplicationBuilder.ApplicationContext context;
    private static ApplicationBuilder.ApplicationContext bareContext;
    private static ApplicationBuilder.ApplicationContext noUserRoleContext;
    private static ApplicationBuilder.ApplicationContext noScopeRoleContext;
    private static ApplicationBuilder.ApplicationContext authContext;
    private static ApplicationBuilder.ApplicationContext noauthContext;
    private static ApplicationBuilder.ApplicationContext misconfiguredAuthContext;
    private static ApplicationBuilder.ApplicationContext invalidClientContext;
    private static String authHeader;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    @Test
    public void testAuthorizeSimpleRequest() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).request().get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeAuthHeaderValid() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("redirect_uri", new Object[]{"http://valid.example.com/redirect"}).request().header("Authorization", (Object)authHeader).get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeAuthHeaderMismatchClientId() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)IdUtil.next())}).request().header("Authorization", (Object)authHeader).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertNull((Object)r.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeAuthHeaderValidNoExplicitClientId() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("redirect_uri", new Object[]{"http://valid.example.com/redirect"}).request().header("Authorization", (Object)authHeader).get();
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)r.getStatus());
        Assert.assertNotNull((Object)r.getLocation());
    }

    @Test
    public void testAuthorizeAuthHeaderInvalid() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)authContext.getClient().getId())}).request().header("Authorization", (Object)"badpassword").get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertNull((Object)r.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeAuthSecretInUrl() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)authContext.getClient().getId())}).queryParam("client_secret", new Object[]{authContext.getClient().getClientSecret()}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertNull((Object)r.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"bad_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeResponseTypeInvalid() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"invalid"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).request().get();
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)r.getStatus());
        URI location = r.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"unsupported_response_type", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testAuthorizeClientIdMalformed() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{"malformed_client_id"}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertNull((Object)r.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"bad_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeClientIdInvalid() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)IdUtil.next())}).request().get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertNull((Object)r.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeScopeSimple() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).request().get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeNoAuthenticator() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)noauthContext.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).request().get();
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)r.getStatus());
        URI location = r.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"invalid_request", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testAuthorizeNotConfiguredAuthenticator() {
        Response r = this.target("/authorize").queryParam("authenticator", new Object[]{"Test"}).queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)misconfiguredAuthContext.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).request().get();
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)r.getStatus());
        URI location = r.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"invalid_request", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testAuthorizeScopeInvalid() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("scope", new Object[]{"invalid"}).request().get();
        Response second = this.followRedirect(r);
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)second.getStatus());
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
        Assert.assertFalse((boolean)params.containsKey((Object)"scope"));
    }

    @Test
    public void testAuthorizeStateSimple() {
        String state = IdUtil.toString((BigInteger)IdUtil.next());
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).queryParam("state", new Object[]{state}).request().get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertEquals((Object)state, (Object)params.getFirst((Object)"state"));
    }

    @Test
    public void testAuthorizeRedirectSimple() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://valid.example.com/redirect"}).request().get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeRedirectState() {
        BigInteger state = IdUtil.next();
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("state", new Object[]{state.toString()}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://valid.example.com/redirect"}).request().get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertEquals((Object)state.toString(), (Object)params.getFirst((Object)"state"));
    }

    @Test
    public void testAuthorizeRedirectMulti() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("redirect_uri", new Object[]{"http://redirect.example.com/redirect"}).request().header("Authorization", (Object)authHeader).get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"redirect.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeRedirectNoneRegistered() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)bareContext.getClient().getId())}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertNull((Object)r.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeRedirectNoneRegisteredWithRequest() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)bareContext.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://redirect.example.com/redirect"}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertNull((Object)r.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeRedirectMultiNoneProvided() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).request().header("Authorization", (Object)authHeader).get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertNull((Object)r.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeRedirectDefault() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).request().get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testAuthorizeRedirectPartial() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://valid.example.com/redirect?foo=bar"}).request().get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
        Assert.assertTrue((boolean)params.containsKey((Object)"foo"));
        Assert.assertEquals((Object)"bar", (Object)params.getFirst((Object)"foo"));
    }

    @Test
    public void testAuthorizeRedirectInvalid() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("redirect_uri", new Object[]{"http://invalid.example.com/redirect"}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertNull((Object)r.getLocation());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testAuthorizeRedirectNoRole() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)noUserRoleContext.getClient().getId())}).request().get();
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI firstLocation = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)firstLocation.getScheme());
        Assert.assertEquals((Object)"localhost", (Object)firstLocation.getHost());
        Assert.assertEquals((Object)"/authorize/callback", (Object)firstLocation.getPath());
        Response second = this.followRedirect(first);
        URI secondLocation = second.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)secondLocation);
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"invalid_scope", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testAuthorizeRedirectRoleWithoutRequestedScope() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{"debug1"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).request().get();
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI firstLocation = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)firstLocation.getScheme());
        Assert.assertEquals((Object)"localhost", (Object)firstLocation.getHost());
        Assert.assertEquals((Object)"/authorize/callback", (Object)firstLocation.getPath());
        Response second = this.followRedirect(first);
        URI secondLocation = second.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)secondLocation);
        Assert.assertTrue((boolean)params.containsKey((Object)"error"));
        Assert.assertEquals((Object)"invalid_scope", (Object)params.getFirst((Object)"error"));
        Assert.assertTrue((boolean)params.containsKey((Object)"error_description"));
    }

    @Test
    public void testAuthorizeRedirectRoleWantsNoScope() {
        Response first = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)noScopeRoleContext.getClient().getId())}).request().get();
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)first.getStatus());
        URI firstLocation = first.getLocation();
        Assert.assertEquals((Object)"http", (Object)firstLocation.getScheme());
        Assert.assertEquals((Object)"localhost", (Object)firstLocation.getHost());
        Assert.assertEquals((Object)"/authorize/callback", (Object)firstLocation.getPath());
        Response second = this.followRedirect(first);
        URI secondLocation = second.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)secondLocation);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertFalse((boolean)params.containsKey((Object)"state"));
    }

    @Test
    public void testTokenSimpleRequest() {
        OAuthToken token = context.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
    }

    @Test
    public void testTokenNoClientId() {
        OAuthToken token = context.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenNoCode() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenNoGrant() {
        OAuthToken token = context.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenNoRedirect() {
        OAuthToken token = context.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenAuthHeaderValid() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://redirect.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testTokenAuthHeaderMismatchClientId() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", "other_client_id");
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"bad_request", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenAuthHeaderValidNoExplicitClientId() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://redirect.example.com/redirect");
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
    }

    @Test
    public void testTokenAuthHeaderInvalid() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        String badHeader = HttpUtil.authHeaderBasic((BigInteger)authContext.getClient().getId(), (String)"invalid_secret");
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)authContext.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)badHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenAuthSecretInBody() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)authContext.getClient().getId()));
        f.param("client_secret", authContext.getClient().getClientSecret());
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://redirect.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
    }

    @Test
    public void testTokenAuthBothMethods() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)authContext.getClient().getId()));
        f.param("client_secret", authContext.getClient().getClientSecret());
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://redirect.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
    }

    @Test
    public void testTokenInvalidGrantTypePassword() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "password");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenInvalidGrantTypeRefreshToken() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "refresh_token");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenInvalidGrantTypeClientCredentials() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "client_credentials");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenUnknownGrantType() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "unknown_grant_type");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenInvalidClient() {
        ApplicationBuilder.ApplicationContext testContext = invalidClientContext.getBuilder().authToken().build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenInvalidCode() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)IdUtil.next()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenMalformedCode() {
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", "not_a_BigInteger");
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"bad_request", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenExpiredCode() {
        OAuthToken token = context.getBuilder().token(OAuthTokenType.Authorization, true, null, null, null).build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenCodeClientMismatch() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenCodeRedirectMismatch() {
        OAuthToken token = context.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://other.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenMultiCodeRedirectMismatch() {
        OAuthToken token = context.getBuilder().token(OAuthTokenType.Authorization, false, null, "http://valid.example.com/redirect", null).build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://other.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenRedirectSimple() {
        OAuthToken token = context.getBuilder().token(OAuthTokenType.Authorization, false, null, "http://valid.example.com/redirect", null).build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testTokenRedirectMulti() {
        OAuthToken token = authContext.getBuilder().token(OAuthTokenType.Authorization, false, null, "http://other.example.com/redirect", null).build().getToken();
        Form f = new Form();
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://other.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testTokenRedirectMultiNoneProvided() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenRedirectDefault() {
        OAuthToken token = authContext.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenRedirectPartial() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().token(OAuthTokenType.Authorization, false, null, "http://valid.example.com/redirect?foo=bar", null).build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect?foo=bar");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testTokenRedirectPartialMismatch() {
        OAuthToken token = context.getBuilder().token(OAuthTokenType.Authorization, false, null, "http://valid.example.com/redirect?foo=bar", null).build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect?lol=cat");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testTokenRedirectInvalid() {
        OAuthToken token = context.getBuilder().authToken().build().getToken();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", IdUtil.toString((BigInteger)token.getId()));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://other.example.com/redirect");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testFullAuthorizationFlow() {
        String state1 = IdUtil.toString((BigInteger)IdUtil.next());
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).queryParam("scope", new Object[]{"debug"}).queryParam("state", new Object[]{state1}).request().get();
        Response second = this.followRedirect(r);
        URI location = second.getLocation();
        Assert.assertEquals((Object)"http", (Object)location.getScheme());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertNull((Object)location.getFragment());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertTrue((boolean)params.containsKey((Object)"code"));
        Assert.assertEquals((Object)state1, (Object)params.getFirst((Object)"state"));
        String state2 = IdUtil.toString((BigInteger)IdUtil.next());
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        f.param("code", (String)params.getFirst((Object)"code"));
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", "http://valid.example.com/redirect");
        f.param("state", state2);
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response tr = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)tr.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)tr.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)tr.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, true);
        Assert.assertEquals((Object)"debug", (Object)entity.getScope());
        Assert.assertEquals((Object)state2, (Object)entity.getState());
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).scope("debug").scope("debug1").role("test", new String[]{"debug"}).client(ClientType.AuthorizationGrant).authenticator(AuthenticatorType.Test).redirect("http://valid.example.com/redirect").user().identity().build();
                bareContext = ApplicationBuilder.newApplication(session).scope("debug").client(ClientType.AuthorizationGrant).authenticator(AuthenticatorType.Test).user().identity().build();
                noScopeRoleContext = ApplicationBuilder.newApplication(session).scope("debug").role("test", new String[0]).client(ClientType.AuthorizationGrant).authenticator(AuthenticatorType.Test).redirect("http://valid.example.com/redirect").build();
                noUserRoleContext = ApplicationBuilder.newApplication(session).scope("debug").client(ClientType.AuthorizationGrant).authenticator(AuthenticatorType.Test).redirect("http://valid.example.com/redirect").build();
                authContext = ApplicationBuilder.newApplication(session).scope("debug").role("test", new String[]{"debug"}).client(ClientType.AuthorizationGrant, true).authenticator(AuthenticatorType.Test).redirect("http://valid.example.com/redirect").redirect("http://redirect.example.com/redirect").user().identity("remote_identity").build();
                noauthContext = ApplicationBuilder.newApplication(session).scope("debug").role("test", new String[]{"debug"}).client(ClientType.AuthorizationGrant).redirect("http://valid.example.com/redirect").build();
                misconfiguredAuthContext = ApplicationBuilder.newApplication(session).client(ClientType.AuthorizationGrant).authenticator(AuthenticatorType.Password).redirect("http://valid.example.com/redirect").scope("debug").build();
                invalidClientContext = ApplicationBuilder.newApplication(session).scope("debug").role("test", new String[]{"debug"}).client(ClientType.Implicit).authenticator(AuthenticatorType.Password).redirect("http://valid.example.com/redirect").build();
                authHeader = HttpUtil.authHeaderBasic((BigInteger)authContext.getClient().getId(), (String)authContext.getClient().getClientSecret());
            }
        };
    }
}

