/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.rfc6749;

import java.io.Serializable;
import java.math.BigInteger;
import javax.ws.rs.core.MultivaluedMap;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientConfig;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.OAuthAPI;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.test.jersey.SingletonTestContainerFactory;
import net.krotscheck.kangaroo.test.runner.SingleInstanceTestRunner;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=SingleInstanceTestRunner.class)
public abstract class AbstractRFC6749Test
extends ContainerTest {
    private SingletonTestContainerFactory testContainerFactory;
    private ResourceConfig testApplication;

    protected final void assertValidBearerToken(MultivaluedMap<String, String> params, boolean requireIdentity) {
        Session s = this.getSession();
        String accessTokenString = (String)params.getFirst((Object)"access_token");
        String tokenType = (String)params.getFirst((Object)"token_type");
        String state = (String)params.getFirst((Object)"state");
        Long expiresIn = Long.valueOf((String)params.getFirst((Object)"expires_in"));
        BigInteger accessTokenId = IdUtil.fromString((String)accessTokenString);
        OAuthToken t = (OAuthToken)s.get(OAuthToken.class, (Serializable)accessTokenId);
        Assert.assertEquals((Object)OAuthTokenType.valueOf((String)tokenType), (Object)t.getTokenType());
        Assert.assertEquals((Object)expiresIn, (Object)t.getExpiresIn());
        TokenResponseEntity entity = TokenResponseEntity.factory((OAuthToken)t, (String)state);
        this.assertValidBearerToken(entity, requireIdentity);
    }

    protected final void assertValidBearerToken(TokenResponseEntity token, boolean requireIdentity) {
        BigInteger refreshTokenId;
        Session s = this.getSession();
        Assert.assertNotNull((Object)token.getAccessToken());
        Assert.assertEquals((Object)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT, (Object)token.getExpiresIn());
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)token.getTokenType());
        OAuthToken bearer = (OAuthToken)s.get(OAuthToken.class, (Serializable)token.getAccessToken());
        Assert.assertNotNull((Object)bearer);
        Assert.assertEquals((Object)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT, (Object)bearer.getExpiresIn());
        Assert.assertEquals((Object)bearer.getTokenType(), (Object)OAuthTokenType.Bearer);
        if (requireIdentity) {
            Assert.assertNotNull((Object)bearer.getIdentity());
        }
        if ((refreshTokenId = token.getRefreshToken()) != null) {
            OAuthToken refresh = (OAuthToken)s.get(OAuthToken.class, (Serializable)refreshTokenId);
            Assert.assertEquals((Object)refresh.getAuthToken(), (Object)bearer);
            Assert.assertEquals((Object)refresh.getIdentity(), (Object)bearer.getIdentity());
            Assert.assertEquals((Object)refresh.getScopes(), (Object)bearer.getScopes());
            Assert.assertEquals((Object)refresh.getTokenType(), (Object)OAuthTokenType.Refresh);
            Assert.assertEquals((Object)refresh.getClient(), (Object)bearer.getClient());
            Assert.assertEquals((Object)ClientConfig.REFRESH_TOKEN_EXPIRES_DEFAULT, (Object)refresh.getExpiresIn());
        }
    }

    protected final TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = new SingletonTestContainerFactory(super.getTestContainerFactory(), ((Object)((Object)this)).getClass());
        }
        return this.testContainerFactory;
    }

    protected final ResourceConfig createApplication() {
        if (this.testApplication == null) {
            this.testApplication = new OAuthAPI();
        }
        return this.testApplication;
    }
}

