/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource.token;

import java.io.Serializable;
import java.util.TimeZone;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientConfig;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.authz.oauth2.resource.token.RefreshTokenGrantHandler;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class RefreshTokenGrantHandlerTest
extends DatabaseTest {
    private static ApplicationBuilder.ApplicationContext ownerCredsContext;
    private static ApplicationBuilder.ApplicationContext authGrantContext;
    private static ApplicationBuilder.ApplicationContext implicitContext;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;
    private RefreshTokenGrantHandler handler;

    @Before
    public void initializeEnvironment() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.handler = new RefreshTokenGrantHandler(this.getSession());
    }

    @Test
    public void testValidAuthorizationGrant() {
        Client authClient = authGrantContext.getClient();
        OAuthToken refreshToken = authGrantContext.getBuilder().bearerToken("debug").refreshToken().build().getToken();
        TokenResponseEntity token = this.handler.handle(authClient, "debug", null, refreshToken.getId());
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)token.getTokenType());
        Assert.assertEquals((long)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT.intValue(), (long)token.getExpiresIn());
        Assert.assertNotNull((Object)token.getAccessToken());
        Assert.assertNotNull((Object)token.getRefreshToken());
        Assert.assertEquals((Object)"debug", (Object)token.getScope());
        OAuthToken newRefresh = (OAuthToken)this.getSession().get(OAuthToken.class, (Serializable)token.getRefreshToken());
        Assert.assertEquals((long)ClientConfig.REFRESH_TOKEN_EXPIRES_DEFAULT.intValue(), (long)newRefresh.getExpiresIn());
        Assert.assertEquals((Object)OAuthTokenType.Refresh, (Object)newRefresh.getTokenType());
        Assert.assertEquals((Object)token.getAccessToken(), (Object)newRefresh.getAuthToken().getId());
        Assert.assertNull((Object)this.getSession().get(OAuthToken.class, (Serializable)refreshToken.getAuthToken().getId()));
        Assert.assertNull((Object)this.getSession().get(OAuthToken.class, (Serializable)refreshToken.getId()));
    }

    @Test
    public void testValidOwnerCredentials() {
        Client authClient = ownerCredsContext.getClient();
        OAuthToken refreshToken = ownerCredsContext.getBuilder().bearerToken("debug").refreshToken().build().getToken();
        TokenResponseEntity token = this.handler.handle(authClient, "debug", null, refreshToken.getId());
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)token.getTokenType());
        Assert.assertEquals((long)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT.intValue(), (long)token.getExpiresIn());
        Assert.assertNotNull((Object)token.getAccessToken());
        Assert.assertNotNull((Object)token.getRefreshToken());
        Assert.assertEquals((Object)"debug", (Object)token.getScope());
        OAuthToken newRefresh = (OAuthToken)this.getSession().get(OAuthToken.class, (Serializable)token.getRefreshToken());
        Assert.assertEquals((long)ClientConfig.REFRESH_TOKEN_EXPIRES_DEFAULT.intValue(), (long)newRefresh.getExpiresIn());
        Assert.assertEquals((Object)OAuthTokenType.Refresh, (Object)newRefresh.getTokenType());
        Assert.assertEquals((Object)token.getAccessToken(), (Object)newRefresh.getAuthToken().getId());
        Assert.assertNull((Object)this.getSession().get(OAuthToken.class, (Serializable)refreshToken.getAuthToken().getId()));
        Assert.assertNull((Object)this.getSession().get(OAuthToken.class, (Serializable)refreshToken.getId()));
    }

    @Test(expected=RFC6749.InvalidGrantException.class)
    public void testInvalidClientType() {
        Client authClient = implicitContext.getClient();
        OAuthToken refreshToken = implicitContext.getBuilder().bearerToken("debug").refreshToken().build().getToken();
        this.handler.handle(authClient, "debug", null, refreshToken.getId());
    }

    @Test(expected=RFC6749.InvalidGrantException.class)
    public void testInvalidRefreshToken() {
        Client authClient = authGrantContext.getClient();
        this.handler.handle(authClient, "debug", null, IdUtil.next());
    }

    @Test(expected=RFC6749.InvalidGrantException.class)
    public void testNullRefreshToken() {
        Client authClient = authGrantContext.getClient();
        this.handler.handle(authClient, "debug", null, null);
    }

    @Test(expected=RFC6749.InvalidGrantException.class)
    public void testNotARefreshToken() {
        Client authClient = authGrantContext.getClient();
        OAuthToken authToken = authGrantContext.getBuilder().bearerToken().build().getToken();
        this.handler.handle(authClient, "debug", null, authToken.getId());
    }

    @Test(expected=RFC6749.InvalidGrantException.class)
    public void testExpiredToken() {
        Client authClient = ownerCredsContext.getClient();
        OAuthToken refreshToken = ownerCredsContext.getBuilder().bearerToken().token(OAuthTokenType.Refresh, true, "debug", null, null).build().getToken();
        this.handler.handle(authClient, "debug", null, refreshToken.getId());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testInvalidScope() {
        Client authClient = authGrantContext.getClient();
        OAuthToken refreshToken = authGrantContext.getBuilder().bearerToken().refreshToken().build().getToken();
        this.handler.handle(authClient, "debug invalid", null, refreshToken.getId());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testEscalateScope() {
        Client authClient = authGrantContext.getClient();
        OAuthToken refreshToken = authGrantContext.getBuilder().bearerToken("debug").refreshToken().build().getToken();
        this.handler.handle(authClient, "debug debug1", null, refreshToken.getId());
    }

    @Test
    public void testDeescalateScope() {
        Client authClient = authGrantContext.getClient();
        OAuthToken refreshToken = authGrantContext.getBuilder().bearerToken("debug").refreshToken().build().getToken();
        TokenResponseEntity token = this.handler.handle(authClient, "", null, refreshToken.getId());
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)token.getTokenType());
        Assert.assertEquals((long)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT.intValue(), (long)token.getExpiresIn());
        Assert.assertNotNull((Object)token.getAccessToken());
        Assert.assertNotNull((Object)token.getRefreshToken());
        Assert.assertNull((Object)token.getScope());
        OAuthToken newRefresh = (OAuthToken)this.getSession().get(OAuthToken.class, (Serializable)token.getRefreshToken());
        Assert.assertEquals((long)ClientConfig.REFRESH_TOKEN_EXPIRES_DEFAULT.intValue(), (long)newRefresh.getExpiresIn());
        Assert.assertEquals((Object)OAuthTokenType.Refresh, (Object)newRefresh.getTokenType());
        Assert.assertEquals((Object)token.getAccessToken(), (Object)newRefresh.getAuthToken().getId());
        Assert.assertNull((Object)this.getSession().get(OAuthToken.class, (Serializable)refreshToken.getAuthToken().getId()));
        Assert.assertNull((Object)this.getSession().get(OAuthToken.class, (Serializable)refreshToken.getId()));
    }

    @Test
    public void testZombieRefresh() {
        Client authClient = authGrantContext.getClient();
        OAuthToken refreshToken = authGrantContext.getBuilder().token(OAuthTokenType.Refresh, false, "debug", null, null).build().getToken();
        TokenResponseEntity token = this.handler.handle(authClient, "", null, refreshToken.getId());
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)token.getTokenType());
        Assert.assertEquals((long)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT.intValue(), (long)token.getExpiresIn());
        Assert.assertNotNull((Object)token.getAccessToken());
        Assert.assertNotNull((Object)token.getRefreshToken());
        Assert.assertNull((Object)token.getScope());
        OAuthToken newRefresh = (OAuthToken)this.getSession().get(OAuthToken.class, (Serializable)token.getRefreshToken());
        Assert.assertEquals((long)ClientConfig.REFRESH_TOKEN_EXPIRES_DEFAULT.intValue(), (long)newRefresh.getExpiresIn());
        Assert.assertEquals((Object)OAuthTokenType.Refresh, (Object)newRefresh.getTokenType());
        Assert.assertEquals((Object)token.getAccessToken(), (Object)newRefresh.getAuthToken().getId());
        Assert.assertNull((Object)this.getSession().get(OAuthToken.class, (Serializable)refreshToken.getId()));
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                authGrantContext = ApplicationBuilder.newApplication(session).client(ClientType.AuthorizationGrant, true).authenticator(AuthenticatorType.Test).scope("debug").scope("debug1").role("test", new String[]{"debug", "debug1"}).user().identity("remote_identity").build();
                ownerCredsContext = ApplicationBuilder.newApplication(session).client(ClientType.OwnerCredentials, true).authenticator(AuthenticatorType.Test).scope("debug").scope("debug1").role("test", new String[]{"debug", "debug1"}).user().identity("remote_identity").build();
                implicitContext = ApplicationBuilder.newApplication(session).client(ClientType.Implicit, true).authenticator(AuthenticatorType.Test).scope("debug").role("test", new String[]{"debug"}).build();
            }
        };
    }
}

