/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource.token;

import java.io.Serializable;
import java.net.URI;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientConfig;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.authz.oauth2.resource.token.ClientCredentialsGrantHandler;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

public final class ClientCredentialsGrantHandlerTest
extends DatabaseTest {
    private static ClientCredentialsGrantHandler handler;
    private static ApplicationBuilder.ApplicationContext context;
    private static ApplicationBuilder.ApplicationContext implicitContext;
    private static ApplicationBuilder.ApplicationContext noScopeContext;
    private static ApplicationBuilder.ApplicationContext noSecretContext;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    @Before
    public void initializeEnvironment() throws Exception {
        UriInfo info = (UriInfo)Mockito.mock(UriInfo.class);
        URI absolutePath = new URI("http://example.com");
        ((UriInfo)Mockito.doReturn((Object)absolutePath).when((Object)info)).getAbsolutePath();
        handler = new ClientCredentialsGrantHandler(this.getSession(), info);
    }

    @Test
    public void testValidRequest() {
        Client testClient = (Client)this.getSession().get(Client.class, (Serializable)context.getClient().getId());
        TokenResponseEntity token = handler.handle(testClient, "debug", null);
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)token.getTokenType());
        Assert.assertEquals((long)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT.intValue(), (long)token.getExpiresIn());
        Assert.assertNull((Object)token.getRefreshToken());
        Assert.assertEquals((Object)"debug", (Object)token.getScope());
        Assert.assertNotNull((Object)token.getAccessToken());
    }

    @Test(expected=KangarooException.class)
    public void testInvalidClientType() {
        handler.handle(implicitContext.getClient(), "debug", null);
    }

    @Test(expected=KangarooException.class)
    public void testNoClientSecret() {
        handler.handle(noSecretContext.getClient(), "debug", null);
    }

    @Test
    public void testInvalidScope() {
        Client testClient = (Client)this.getSession().get(Client.class, (Serializable)context.getClient().getId());
        TokenResponseEntity token = handler.handle(testClient, "debug", null);
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)token.getTokenType());
        Assert.assertEquals((long)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT.intValue(), (long)token.getExpiresIn());
        Assert.assertNull((Object)token.getRefreshToken());
        Assert.assertEquals((Object)"debug", (Object)token.getScope());
        Assert.assertNotNull((Object)token.getAccessToken());
    }

    @Test
    public void testNoScope() {
        Client c = noScopeContext.getClient();
        TokenResponseEntity token = handler.handle(c, "debug", null);
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)token.getTokenType());
        Assert.assertEquals((long)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT.intValue(), (long)token.getExpiresIn());
        Assert.assertNull((Object)token.getRefreshToken());
        Assert.assertNull((Object)token.getScope());
        Assert.assertNotNull((Object)token.getAccessToken());
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).client(ClientType.ClientCredentials, true).scope("debug").build();
                noScopeContext = ApplicationBuilder.newApplication(session).client(ClientType.ClientCredentials, true).build();
                implicitContext = ApplicationBuilder.newApplication(session).client(ClientType.Implicit, true).scope("debug").build();
                noSecretContext = ApplicationBuilder.newApplication(session).client(ClientType.ClientCredentials).scope("debug").build();
            }
        };
    }
}

