/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import java.math.BigInteger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientConfig;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.OAuthAPI;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import org.glassfish.jersey.server.ResourceConfig;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class TokenServiceTest
extends ContainerTest {
    private static ApplicationBuilder.ApplicationContext context;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    protected ResourceConfig createApplication() {
        return new OAuthAPI();
    }

    @Test
    public void testInvalidGrantType() {
        Form testData = new Form();
        testData.param("grant_type", "invalid");
        testData.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        testData.param("client_secret", context.getClient().getClientSecret());
        Entity testEntity = Entity.entity((Object)testData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response response = this.target("/token").request().post(testEntity);
        ErrorResponseBuilder.ErrorResponse error = (ErrorResponseBuilder.ErrorResponse)response.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"invalid_grant", (Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorDescription());
    }

    @Test
    public void testValidGrantType() {
        Form testData = new Form();
        testData.param("grant_type", "client_credentials");
        testData.param("client_id", IdUtil.toString((BigInteger)context.getClient().getId()));
        testData.param("client_secret", context.getClient().getClientSecret());
        Entity testEntity = Entity.entity((Object)testData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        TokenResponseEntity token = (TokenResponseEntity)this.target("/token").request().post(testEntity, TokenResponseEntity.class);
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)token.getTokenType());
        Assert.assertEquals((long)ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT.intValue(), (long)token.getExpiresIn());
        Assert.assertNull((Object)token.getRefreshToken());
        Assert.assertNull((Object)token.getScope());
        Assert.assertNotNull((Object)token.getAccessToken());
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).client(ClientType.ClientCredentials, true).build();
            }
        };
    }
}

