/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import java.math.BigInteger;
import java.util.TreeMap;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.junit.Assert;
import org.junit.Test;

public final class TokenResponseEntityTest {
    @Test
    public void testFactoryNoRefresh() {
        OAuthToken token = new OAuthToken();
        token.setId(IdUtil.next());
        token.setTokenType(OAuthTokenType.Bearer);
        token.setExpiresIn(100);
        TreeMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();
        ApplicationScope debug = new ApplicationScope();
        debug.setName("debug");
        ApplicationScope test = new ApplicationScope();
        test.setName("test");
        scopes.put("debug", debug);
        scopes.put("test", test);
        token.setScopes(scopes);
        String state = IdUtil.toString((BigInteger)IdUtil.next());
        TokenResponseEntity entity = TokenResponseEntity.factory((OAuthToken)token, (String)state);
        Assert.assertEquals((Object)token.getId(), (Object)entity.getAccessToken());
        Assert.assertEquals((long)token.getExpiresIn(), (long)entity.getExpiresIn());
        Assert.assertEquals((Object)"Bearer", (Object)entity.getTokenType().toString());
        Assert.assertEquals((Object)"debug test", (Object)entity.getScope());
        Assert.assertNull((Object)entity.getRefreshToken());
        Assert.assertEquals((Object)state, (Object)entity.getState());
    }

    @Test
    public void testFactoryRefresh() {
        OAuthToken token = new OAuthToken();
        token.setId(IdUtil.next());
        token.setTokenType(OAuthTokenType.Bearer);
        token.setExpiresIn(100);
        TreeMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();
        ApplicationScope debug = new ApplicationScope();
        debug.setName("debug");
        ApplicationScope test = new ApplicationScope();
        test.setName("test");
        scopes.put("debug", debug);
        scopes.put("test", test);
        token.setScopes(scopes);
        OAuthToken refresh = new OAuthToken();
        refresh.setId(IdUtil.next());
        refresh.setTokenType(OAuthTokenType.Refresh);
        String state = IdUtil.toString((BigInteger)IdUtil.next());
        TokenResponseEntity entity = TokenResponseEntity.factory((OAuthToken)token, (OAuthToken)refresh, (String)state);
        Assert.assertEquals((Object)token.getId(), (Object)entity.getAccessToken());
        Assert.assertEquals((long)token.getExpiresIn(), (long)entity.getExpiresIn());
        Assert.assertEquals((Object)"Bearer", (Object)entity.getTokenType().toString());
        Assert.assertEquals((Object)"debug test", (Object)entity.getScope());
        Assert.assertEquals((Object)refresh.getId(), (Object)entity.getRefreshToken());
        Assert.assertEquals((Object)state, (Object)entity.getState());
    }

    @Test
    public void testFactoryNoScope() {
        OAuthToken token = new OAuthToken();
        token.setId(IdUtil.next());
        token.setTokenType(OAuthTokenType.Bearer);
        token.setExpiresIn(100);
        TreeMap scopes = new TreeMap();
        token.setScopes(scopes);
        OAuthToken refresh = new OAuthToken();
        refresh.setId(IdUtil.next());
        refresh.setTokenType(OAuthTokenType.Refresh);
        String state = IdUtil.toString((BigInteger)IdUtil.next());
        TokenResponseEntity entity = TokenResponseEntity.factory((OAuthToken)token, (OAuthToken)refresh, (String)state);
        Assert.assertEquals((Object)token.getId(), (Object)entity.getAccessToken());
        Assert.assertEquals((long)token.getExpiresIn(), (long)entity.getExpiresIn());
        Assert.assertEquals((Object)"Bearer", (Object)entity.getTokenType().toString());
        Assert.assertNull((Object)entity.getScope());
        Assert.assertEquals((Object)refresh.getId(), (Object)entity.getRefreshToken());
        Assert.assertEquals((Object)state, (Object)entity.getState());
    }
}

