/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.oauth2.resource.IntrospectionResponseEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import net.krotscheck.kangaroo.util.StringUtil;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;

public final class IntrospectionResponseEntityTest {
    private OAuthToken buildToken() {
        Calendar now = Calendar.getInstance();
        now.set(14, 0);
        Application a = new Application();
        a.setId(IdUtil.next());
        Client c = new Client();
        c.setId(IdUtil.next());
        c.setApplication(a);
        OAuthToken token = new OAuthToken();
        token.setId(IdUtil.next());
        token.setCreatedDate(now);
        token.setModifiedDate(now);
        token.setExpiresIn(600);
        token.setTokenType(OAuthTokenType.Bearer);
        token.setClient(c);
        token.setIssuer("localhost");
        return token;
    }

    private UserIdentity buildIdentity() {
        User u = new User();
        u.setId(IdUtil.next());
        UserIdentity i = new UserIdentity();
        i.setId(IdUtil.next());
        i.setRemoteId(RandomStringUtils.randomAlphanumeric((int)10));
        i.setUser(u);
        return i;
    }

    private SortedMap<String, ApplicationScope> buildScopes() {
        TreeMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();
        Arrays.stream(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).forEach(i -> {
            ApplicationScope a = new ApplicationScope();
            a.setId(IdUtil.next());
            a.setName(RandomStringUtils.randomAlphanumeric((int)10));
            scopes.put(a.getName(), a);
        });
        return scopes;
    }

    @Test
    public void testBasicConstructor() {
        IntrospectionResponseEntity entity = new IntrospectionResponseEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)entity.isActive());
        Assert.assertNull((Object)entity.getClientId());
        Assert.assertNull((Object)entity.getTokenType());
        Assert.assertNull((Object)entity.getIat());
        Assert.assertNull((Object)entity.getJti());
        Assert.assertNull((Object)entity.getNbf());
        Assert.assertNull((Object)entity.getAud());
        Assert.assertNull((Object)entity.getIss());
        Assert.assertNull((Object)entity.getScope());
        Assert.assertNull((Object)entity.getSub());
        Assert.assertNull((Object)entity.getUsername());
        Assert.assertNull((Object)entity.getExp());
    }

    @Test
    public void testIdentityBearerConstructor() {
        OAuthToken token = this.buildToken();
        token.setTokenType(OAuthTokenType.Bearer);
        token.setScopes(this.buildScopes());
        token.setIdentity(this.buildIdentity());
        IntrospectionResponseEntity entity = new IntrospectionResponseEntity(token);
        Assert.assertEquals((Object)token.getClient().getId(), (Object)entity.getClientId());
        Assert.assertEquals((Object)token.getTokenType(), (Object)entity.getTokenType());
        Assert.assertEquals((Object)token.getCreatedDate(), (Object)entity.getIat());
        Assert.assertEquals((Object)(!token.isExpired() ? 1 : 0), (Object)entity.isActive());
        Assert.assertEquals((Object)token.getId(), (Object)entity.getJti());
        Assert.assertEquals((Object)token.getCreatedDate(), (Object)entity.getNbf());
        Assert.assertEquals((Object)token.getClient().getApplication().getId(), (Object)entity.getAud());
        Assert.assertEquals((Object)entity.getIss(), (Object)token.getIssuer());
        Calendar expires = (Calendar)token.getCreatedDate().clone();
        expires.add(13, token.getExpiresIn().intValue());
        Assert.assertEquals((Object)expires, (Object)entity.getExp());
        String scopes = StringUtil.sameOrDefault((String)entity.getScope(), (String)"");
        List<String> scopeList = Arrays.asList(scopes.split(" "));
        ArrayList tokenScopes = new ArrayList(token.getScopes().keySet());
        Assert.assertEquals(scopeList, tokenScopes);
        Assert.assertEquals((Object)token.getIdentity().getRemoteId(), (Object)entity.getUsername());
        Assert.assertEquals((Object)token.getIdentity().getUser().getId(), (Object)entity.getSub());
    }

    @Test
    public void testClientBearerConstructor() {
        OAuthToken token = this.buildToken();
        token.getClient().setType(ClientType.ClientCredentials);
        token.setTokenType(OAuthTokenType.Bearer);
        token.setScopes(this.buildScopes());
        IntrospectionResponseEntity entity = new IntrospectionResponseEntity(token);
        Assert.assertEquals((Object)token.getClient().getId(), (Object)entity.getClientId());
        Assert.assertEquals((Object)token.getTokenType(), (Object)entity.getTokenType());
        Assert.assertEquals((Object)token.getCreatedDate(), (Object)entity.getIat());
        Assert.assertEquals((Object)(!token.isExpired() ? 1 : 0), (Object)entity.isActive());
        Assert.assertEquals((Object)token.getId(), (Object)entity.getJti());
        Assert.assertEquals((Object)token.getCreatedDate(), (Object)entity.getNbf());
        Assert.assertEquals((Object)token.getClient().getApplication().getId(), (Object)entity.getAud());
        Assert.assertEquals((Object)entity.getIss(), (Object)token.getIssuer());
        Calendar expires = (Calendar)token.getCreatedDate().clone();
        expires.add(13, token.getExpiresIn().intValue());
        Assert.assertEquals((Object)expires, (Object)entity.getExp());
        String scopes = StringUtil.sameOrDefault((String)entity.getScope(), (String)"");
        List<String> scopeList = Arrays.asList(scopes.split(" "));
        ArrayList tokenScopes = new ArrayList(token.getScopes().keySet());
        Assert.assertEquals(scopeList, tokenScopes);
        Assert.assertNull((Object)entity.getUsername());
        Assert.assertEquals((Object)token.getClient().getId(), (Object)entity.getSub());
    }

    @Test
    public void testRefreshConstructor() {
        OAuthToken token = this.buildToken();
        token.setTokenType(OAuthTokenType.Refresh);
        token.setScopes(this.buildScopes());
        token.setIdentity(this.buildIdentity());
        IntrospectionResponseEntity entity = new IntrospectionResponseEntity(token);
        Assert.assertEquals((Object)token.getClient().getId(), (Object)entity.getClientId());
        Assert.assertEquals((Object)token.getTokenType(), (Object)entity.getTokenType());
        Assert.assertEquals((Object)token.getCreatedDate(), (Object)entity.getIat());
        Assert.assertEquals((Object)(!token.isExpired() ? 1 : 0), (Object)entity.isActive());
        Assert.assertEquals((Object)token.getId(), (Object)entity.getJti());
        Assert.assertEquals((Object)token.getCreatedDate(), (Object)entity.getNbf());
        Assert.assertEquals((Object)token.getClient().getApplication().getId(), (Object)entity.getAud());
        Assert.assertEquals((Object)entity.getIss(), (Object)token.getIssuer());
        Calendar expires = (Calendar)token.getCreatedDate().clone();
        expires.add(13, token.getExpiresIn().intValue());
        Assert.assertEquals((Object)expires, (Object)entity.getExp());
        String scopes = StringUtil.sameOrDefault((String)entity.getScope(), (String)"");
        List<String> scopeList = Arrays.asList(scopes.split(" "));
        ArrayList tokenScopes = new ArrayList(token.getScopes().keySet());
        Assert.assertEquals(scopeList, tokenScopes);
        Assert.assertEquals((Object)token.getIdentity().getRemoteId(), (Object)entity.getUsername());
        Assert.assertEquals((Object)token.getIdentity().getUser().getId(), (Object)entity.getSub());
    }

    @Test
    public void testAuthCodeConstructor() {
        OAuthToken token = this.buildToken();
        token.setTokenType(OAuthTokenType.Authorization);
        token.setScopes(this.buildScopes());
        token.setIdentity(this.buildIdentity());
        IntrospectionResponseEntity entity = new IntrospectionResponseEntity(token);
        Assert.assertEquals((Object)token.getClient().getId(), (Object)entity.getClientId());
        Assert.assertEquals((Object)token.getTokenType(), (Object)entity.getTokenType());
        Assert.assertEquals((Object)token.getCreatedDate(), (Object)entity.getIat());
        Assert.assertEquals((Object)(!token.isExpired() ? 1 : 0), (Object)entity.isActive());
        Assert.assertEquals((Object)token.getId(), (Object)entity.getJti());
        Assert.assertEquals((Object)token.getCreatedDate(), (Object)entity.getNbf());
        Assert.assertEquals((Object)token.getClient().getApplication().getId(), (Object)entity.getAud());
        Assert.assertEquals((Object)entity.getIss(), (Object)token.getIssuer());
        Calendar expires = (Calendar)token.getCreatedDate().clone();
        expires.add(13, token.getExpiresIn().intValue());
        Assert.assertEquals((Object)expires, (Object)entity.getExp());
        String scopes = StringUtil.sameOrDefault((String)entity.getScope(), (String)"");
        List<String> scopeList = Arrays.asList(scopes.split(" "));
        ArrayList tokenScopes = new ArrayList(token.getScopes().keySet());
        Assert.assertEquals(scopeList, tokenScopes);
        Assert.assertEquals((Object)token.getIdentity().getRemoteId(), (Object)entity.getUsername());
        Assert.assertEquals((Object)token.getIdentity().getUser().getId(), (Object)entity.getSub());
    }

    @Test
    public void testNullConstructor() {
        IntrospectionResponseEntity entity = new IntrospectionResponseEntity(null);
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)entity.isActive());
        Assert.assertNull((Object)entity.getClientId());
        Assert.assertNull((Object)entity.getTokenType());
        Assert.assertNull((Object)entity.getIat());
        Assert.assertNull((Object)entity.getJti());
        Assert.assertNull((Object)entity.getNbf());
        Assert.assertNull((Object)entity.getAud());
        Assert.assertNull((Object)entity.getIss());
        Assert.assertNull((Object)entity.getScope());
        Assert.assertNull((Object)entity.getSub());
        Assert.assertNull((Object)entity.getUsername());
        Assert.assertNull((Object)entity.getExp());
    }

    @Test
    public void testExpiredConstructor() {
        OAuthToken token = this.buildToken();
        token.setTokenType(OAuthTokenType.Bearer);
        token.setScopes(this.buildScopes());
        token.setIdentity(this.buildIdentity());
        Calendar then = Calendar.getInstance();
        then.add(2, -12);
        token.setCreatedDate(then);
        token.setModifiedDate(then);
        Assert.assertTrue((boolean)token.isExpired());
        IntrospectionResponseEntity entity = new IntrospectionResponseEntity(token);
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)entity.isActive());
        Assert.assertNull((Object)entity.getClientId());
        Assert.assertNull((Object)entity.getTokenType());
        Assert.assertNull((Object)entity.getIat());
        Assert.assertNull((Object)entity.getJti());
        Assert.assertNull((Object)entity.getNbf());
        Assert.assertNull((Object)entity.getAud());
        Assert.assertNull((Object)entity.getIss());
        Assert.assertNull((Object)entity.getScope());
        Assert.assertNull((Object)entity.getSub());
        Assert.assertNull((Object)entity.getUsername());
        Assert.assertNull((Object)entity.getExp());
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        OAuthToken token = this.buildToken();
        token.setTokenType(OAuthTokenType.Bearer);
        token.setScopes(this.buildScopes());
        token.setIdentity(this.buildIdentity());
        IntrospectionResponseEntity entity = new IntrospectionResponseEntity(token);
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)entity);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)entity.isActive(), (Object)node.get("active").asBoolean());
        Assert.assertEquals((Object)entity.getScope(), (Object)node.get("scope").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)entity.getClientId()), (Object)node.get("client_id").asText());
        Assert.assertEquals((Object)entity.getUsername(), (Object)node.get("username").asText());
        Assert.assertEquals((Object)entity.getTokenType().toString(), (Object)node.get("token_type").asText());
        Assert.assertEquals((long)(entity.getExp().getTimeInMillis() / 1000L), (long)node.get("exp").asLong());
        Assert.assertEquals((long)(entity.getIat().getTimeInMillis() / 1000L), (long)node.get("iat").asLong());
        Assert.assertEquals((long)(entity.getNbf().getTimeInMillis() / 1000L), (long)node.get("nbf").asLong());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)entity.getSub()), (Object)node.get("sub").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)entity.getAud()), (Object)node.get("aud").asText());
        Assert.assertEquals((Object)entity.getIss(), (Object)node.get("iss").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)entity.getJti()), (Object)node.get("jti").asText());
    }
}

