/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.krotscheck.kangaroo.authz.oauth2.resource.GrantType;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;

public final class GrantTypeTest {
    @Test
    public void testSerialization() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        String auth = m.writeValueAsString((Object)GrantType.AuthorizationCode);
        Assert.assertEquals((Object)"\"authorization_code\"", (Object)auth);
        String cc = m.writeValueAsString((Object)GrantType.ClientCredentials);
        Assert.assertEquals((Object)"\"client_credentials\"", (Object)cc);
        String pswd = m.writeValueAsString((Object)GrantType.Password);
        Assert.assertEquals((Object)"\"password\"", (Object)pswd);
        String refresh = m.writeValueAsString((Object)GrantType.RefreshToken);
        Assert.assertEquals((Object)"\"refresh_token\"", (Object)refresh);
    }

    @Test
    public void testDeserialization() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        GrantType auth = (GrantType)m.readValue("\"authorization_code\"", GrantType.class);
        Assert.assertSame((Object)auth, (Object)GrantType.AuthorizationCode);
        GrantType implicit = (GrantType)m.readValue("\"client_credentials\"", GrantType.class);
        Assert.assertSame((Object)implicit, (Object)GrantType.ClientCredentials);
        GrantType owner = (GrantType)m.readValue("\"password\"", GrantType.class);
        Assert.assertSame((Object)owner, (Object)GrantType.Password);
        GrantType client = (GrantType)m.readValue("\"refresh_token\"", GrantType.class);
        Assert.assertSame((Object)client, (Object)GrantType.RefreshToken);
    }

    @Test
    public void testFromString() {
        Assert.assertEquals((Object)GrantType.AuthorizationCode, (Object)GrantType.fromString((String)"authorization_code"));
        Assert.assertEquals((Object)GrantType.ClientCredentials, (Object)GrantType.fromString((String)"client_credentials"));
        Assert.assertEquals((Object)GrantType.Password, (Object)GrantType.fromString((String)"password"));
        Assert.assertEquals((Object)GrantType.RefreshToken, (Object)GrantType.fromString((String)"refresh_token"));
    }

    @Test
    public void testValueOf() {
        Assert.assertEquals((Object)GrantType.AuthorizationCode, (Object)GrantType.valueOf((String)"AuthorizationCode"));
        Assert.assertEquals((Object)GrantType.ClientCredentials, (Object)GrantType.valueOf((String)"ClientCredentials"));
        Assert.assertEquals((Object)GrantType.Password, (Object)GrantType.valueOf((String)"Password"));
        Assert.assertEquals((Object)GrantType.RefreshToken, (Object)GrantType.valueOf((String)"RefreshToken"));
    }
}

