/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.oauth2.OAuthAPI;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.server.ResourceConfig;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class AuthorizationServiceTest
extends ContainerTest {
    private static ApplicationBuilder.ApplicationContext context;
    private static ApplicationBuilder.ApplicationContext ownerContext;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    protected ResourceConfig createApplication() {
        return new OAuthAPI();
    }

    @Test
    public void testInvalidResponseType() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"invalid"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).request().get();
        Assert.assertEquals((long)Response.Status.FOUND.getStatusCode(), (long)r.getStatus());
        URI location = r.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertEquals((Object)"unsupported_response_type", (Object)params.getFirst((Object)"error"));
        Assert.assertNotNull((Object)params.get((Object)"error_description"));
    }

    @Test
    public void testValidResponseType() {
        Response r = this.target("/authorize").queryParam("response_type", new Object[]{"test"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)context.getClient().getId())}).request().get();
        URI location = r.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertEquals((Object)"unsupported_response_type", (Object)params.getFirst((Object)"error"));
        Assert.assertNotNull((Object)params.get((Object)"error_description"));
    }

    @Test
    public void testCallbackMalformedStateId() {
        Response r = this.target("/authorize/callback").queryParam("state", new Object[]{"not_a_parseable_BigInteger"}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        ErrorResponseBuilder.ErrorResponse e = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)e.getError());
        Assert.assertNotNull((Object)e.getErrorDescription());
    }

    @Test
    public void testCallbackInvalidStateId() {
        Response r = this.target("/authorize/callback").queryParam("state", new Object[]{IdUtil.toString((BigInteger)IdUtil.next())}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        ErrorResponseBuilder.ErrorResponse e = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_request", (Object)e.getError());
        Assert.assertNotNull((Object)e.getErrorDescription());
    }

    @Test
    public void testCallbackStateWithInvalidClientType() throws Exception {
        Response r = this.target("/authorize/callback").queryParam("state", new Object[]{IdUtil.toString((BigInteger)ownerContext.getAuthenticatorState().getId())}).request().get();
        URI location = r.getLocation();
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getQuery());
        Assert.assertEquals((Object)"valid.example.com", (Object)location.getHost());
        Assert.assertEquals((Object)"/redirect", (Object)location.getPath());
        Assert.assertEquals((Object)"invalid_request", (Object)params.getFirst((Object)"error"));
        Assert.assertNotNull((Object)params.get((Object)"error_description"));
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).client(ClientType.Implicit).authenticator(AuthenticatorType.Test).redirect("http://valid.example.com/redirect").build();
                ownerContext = ApplicationBuilder.newApplication(session).client(ClientType.OwnerCredentials).authenticator(AuthenticatorType.Test).redirect("http://valid.example.com/redirect").authenticatorState().build();
            }
        };
    }
}

