/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.exception;

import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.exception.RedirectingException;
import net.krotscheck.kangaroo.authz.oauth2.exception.RedirectingExceptionMapper;
import net.krotscheck.kangaroo.common.exception.mapper.KangarooExceptionMapper;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.junit.Assert;
import org.junit.Test;

public final class RedirectingExceptionMapperTest {
    @Test
    public void testRegularMapping() throws Exception {
        RFC6749.InvalidClientException ke = new RFC6749.InvalidClientException();
        InjectionManager injector = Injections.createInjectionManager();
        ExceptionMapperFactory mappers = new ExceptionMapperFactory(injector);
        injector.register((Binder)new KangarooExceptionMapper.Binder());
        injector.register((Binder)new RedirectingExceptionMapper.Binder());
        injector.register(Bindings.service((Object)mappers).to(ExceptionMappers.class));
        RedirectingExceptionMapper mapper = (RedirectingExceptionMapper)injector.getInstance(RedirectingExceptionMapper.class);
        URI redirect = UriBuilder.fromUri((String)"http://redirect.example.com/").build(new Object[0]);
        RedirectingException re = new RedirectingException((Throwable)ke, redirect, ClientType.AuthorizationGrant);
        Response r = mapper.toResponse(re);
        Assert.assertEquals((long)302L, (long)r.getStatus());
        URI location = UriBuilder.fromUri((String)r.getHeaderString("Location")).build(new Object[0]);
        Assert.assertEquals((Object)location.getScheme(), (Object)redirect.getScheme());
        Assert.assertEquals((Object)location.getHost(), (Object)redirect.getHost());
        Assert.assertEquals((long)location.getPort(), (long)redirect.getPort());
        Assert.assertEquals((Object)location.getPath(), (Object)redirect.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)location);
        Assert.assertEquals((Object)params.getFirst((Object)"error"), (Object)ke.getCode().getError());
        Assert.assertEquals((Object)params.getFirst((Object)"error_description"), (Object)ke.getCode().getErrorDescription());
    }

    @Test
    public void testImplicitMapping() throws Exception {
        RFC6749.InvalidClientException ke = new RFC6749.InvalidClientException();
        InjectionManager injector = Injections.createInjectionManager();
        ExceptionMapperFactory mappers = new ExceptionMapperFactory(injector);
        injector.register((Binder)new KangarooExceptionMapper.Binder());
        injector.register((Binder)new RedirectingExceptionMapper.Binder());
        injector.register(Bindings.service((Object)mappers).to(ExceptionMappers.class));
        RedirectingExceptionMapper mapper = (RedirectingExceptionMapper)injector.getInstance(RedirectingExceptionMapper.class);
        URI redirect = UriBuilder.fromUri((String)"http://redirect.example.com/").build(new Object[0]);
        RedirectingException re = new RedirectingException((Throwable)ke, redirect, ClientType.Implicit);
        Response r = mapper.toResponse(re);
        Assert.assertEquals((long)302L, (long)r.getStatus());
        URI location = UriBuilder.fromUri((String)r.getHeaderString("Location")).build(new Object[0]);
        Assert.assertEquals((Object)location.getScheme(), (Object)redirect.getScheme());
        Assert.assertEquals((Object)location.getHost(), (Object)redirect.getHost());
        Assert.assertEquals((long)location.getPort(), (long)redirect.getPort());
        Assert.assertEquals((Object)location.getPath(), (Object)redirect.getPath());
        MultivaluedMap params = HttpUtil.parseQueryParams((String)location.getFragment());
        Assert.assertEquals((Object)params.getFirst((Object)"error"), (Object)ke.getCode().getError());
        Assert.assertEquals((Object)params.getFirst((Object)"error_description"), (Object)ke.getCode().getErrorDescription());
        injector.shutdown();
    }
}

