/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.exception;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import org.junit.Assert;
import org.junit.Test;

public final class RFC6749Test {
    @Test
    public void testPrivateConstructor() throws Exception {
        Constructor c = RFC6749.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(c.getModifiers()));
        c.setAccessible(true);
        c.newInstance(new Object[0]);
    }

    @Test
    public void testErrors() throws Exception {
        this.validateCodeInException("access_denied", RFC6749.AccessDeniedException.class);
        this.validateCodeInException("invalid_client", RFC6749.InvalidClientException.class);
        this.validateCodeInException("invalid_grant", RFC6749.InvalidGrantException.class);
        this.validateCodeInException("invalid_request", RFC6749.InvalidRequestException.class);
        this.validateCodeInException("invalid_scope", RFC6749.InvalidScopeException.class);
        this.validateCodeInException("server_error", RFC6749.ServerErrorException.class);
        this.validateCodeInException("temporarily_unavailable", RFC6749.TemporarilyUnavailableException.class);
        this.validateCodeInException("unauthorized_client", RFC6749.UnauthorizedClientException.class);
        this.validateCodeInException("unsupported_grant_type", RFC6749.UnsupportedGrantTypeException.class);
        this.validateCodeInException("unsupported_response_type", RFC6749.UnsupportedResponseTypeException.class);
    }

    private void validateCodeInException(String expectedCode, Class<? extends KangarooException> errorClass) throws Exception {
        KangarooException e = errorClass.newInstance();
        Assert.assertEquals((Object)expectedCode, (Object)e.getCode().getError());
    }
}

