/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authz;

import java.security.Principal;
import javax.ws.rs.container.ContainerRequestContext;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2SecurityContext;
import net.krotscheck.kangaroo.authz.oauth2.authn.authz.O2AuthorizationFilter;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class O2AuthorizationFilterTest {
    private ContainerRequestContext requestContext;
    private O2SecurityContext securityContext;

    @Before
    public void setup() {
        this.requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        this.securityContext = (O2SecurityContext)Mockito.mock(O2SecurityContext.class);
        ((ContainerRequestContext)Mockito.doReturn((Object)this.securityContext).when((Object)this.requestContext)).getSecurityContext();
    }

    @Test(expected=RFC6749.AccessDeniedException.class)
    public void assertFailWithWrongPrincipalType() {
        O2AuthorizationFilter filter = new O2AuthorizationFilter();
        Principal principal = () -> "wrong type";
        ((O2SecurityContext)Mockito.doReturn((Object)principal).when((Object)this.securityContext)).getUserPrincipal();
        filter.filter(this.requestContext);
    }

    @Test(expected=RFC6749.AccessDeniedException.class)
    public void assertFailWithNoPrincipal() {
        O2AuthorizationFilter filter = new O2AuthorizationFilter();
        ((O2SecurityContext)Mockito.doReturn(null).when((Object)this.securityContext)).getUserPrincipal();
        filter.filter(this.requestContext);
    }

    @Test(expected=RFC6749.AccessDeniedException.class)
    public void assertFailWithNoClient() {
        O2AuthorizationFilter filter = new O2AuthorizationFilter();
        O2Principal p = new O2Principal();
        ((O2SecurityContext)Mockito.doReturn((Object)p).when((Object)this.securityContext)).getUserPrincipal();
        filter.filter(this.requestContext);
    }

    @Test
    public void assertPassWithPublicClient() {
        O2AuthorizationFilter filter = new O2AuthorizationFilter();
        Client c = new Client();
        c.setId(IdUtil.next());
        O2Principal p = new O2Principal(c);
        ((O2SecurityContext)Mockito.doReturn((Object)p).when((Object)this.securityContext)).getUserPrincipal();
        filter.filter(this.requestContext);
    }
}

