/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authn;

import java.math.BigInteger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.FirstRunContainerLifecycleListener;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.ServletConfigFactory;
import net.krotscheck.kangaroo.authz.admin.v1.test.rule.TestDataResource;
import net.krotscheck.kangaroo.authz.common.database.DatabaseFeature;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2AuthDynamicFeature;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.O2TestResource;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.config.ConfigurationFeature;
import net.krotscheck.kangaroo.common.exception.ExceptionFeature;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public final class O2ClientQueryParameterFilterTest
extends ContainerTest {
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE);

    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(ConfigurationFeature.class);
        a.register(DatabaseFeature.class);
        a.register(ExceptionFeature.class);
        a.register((Object)new ServletConfigFactory.Binder());
        a.register((Object)new FirstRunContainerLifecycleListener.Binder());
        a.register(O2AuthDynamicFeature.class);
        a.register(O2TestResource.class);
        return a;
    }

    @Test
    public void testNoParam() {
        Response r = this.target("/client").request().get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testNoClientAuthParams() {
        Response r = this.target("/client").queryParam("hello", new Object[]{"world"}).queryParam("hello", new Object[]{"kitty"}).request().get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testMalformedClientId() {
        Response r = this.target("/client").queryParam("client_id", new Object[]{"not_a_biginteger"}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testNonexistentClientId() {
        Response r = this.target("/client").queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)IdUtil.next())}).request().get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testDuplicateClientIds() {
        ApplicationBuilder b = TEST_DATA_RESOURCE.getAdminApplication().getBuilder();
        Client c1 = b.client(ClientType.Implicit, false).build().getClient();
        Client c2 = b.client(ClientType.Implicit, false).build().getClient();
        Response r = this.target("/client").queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)c1.getId())}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)c2.getId())}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testValidPrivateClient() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.AuthorizationGrant, true).build().getClient();
        Response r = this.target("/client").queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)c.getId())}).queryParam("client_secret", new Object[]{c.getClientSecret()}).request().get();
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testValidPublicClient() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.Implicit, false).build().getClient();
        Response r = this.target("/client").queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)c.getId())}).request().get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testPUTClient() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.Implicit, false).build().getClient();
        Form requestData = new Form();
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)c.getId())}).request().put(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void tesPOSTClient() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.Implicit, false).build().getClient();
        Form requestData = new Form();
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)c.getId())}).request().post(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }
}

