/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authn;

import java.math.BigInteger;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.FirstRunContainerLifecycleListener;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.ServletConfigFactory;
import net.krotscheck.kangaroo.authz.admin.v1.test.rule.TestDataResource;
import net.krotscheck.kangaroo.authz.common.database.DatabaseFeature;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2AuthDynamicFeature;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.O2TestResource;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.config.ConfigurationFeature;
import net.krotscheck.kangaroo.common.exception.ExceptionFeature;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public final class O2ClientBodyFilterTest
extends ContainerTest {
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE);

    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(ConfigurationFeature.class);
        a.register(DatabaseFeature.class);
        a.register(ExceptionFeature.class);
        a.register((Object)new ServletConfigFactory.Binder());
        a.register((Object)new FirstRunContainerLifecycleListener.Binder());
        a.register(O2AuthDynamicFeature.class);
        a.register(O2TestResource.class);
        return a;
    }

    @Test
    public void testNoBody() {
        Form requestData = new Form();
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testNoClientAuthParams() {
        Form requestData = new Form();
        requestData.param("hello", "world");
        requestData.param("hello", "kitty");
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testInvalidBodyEncodingType() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getClient();
        HashMap<String, String> requestData = new HashMap<String, String>();
        requestData.put("client_id", IdUtil.toString((BigInteger)c.getId()));
        requestData.put("client_secret", c.getClientSecret());
        Entity testEntity = Entity.entity(requestData, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testMalformedClientId() {
        Form requestData = new Form();
        requestData.param("client_id", "malformed client id");
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testNonexistentClientId() {
        Form requestData = new Form();
        requestData.param("client_id", IdUtil.toString((BigInteger)IdUtil.next()));
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testBadSecret() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.AuthorizationGrant, true).build().getClient();
        Assert.assertTrue((boolean)c.isPrivate());
        Form requestData = new Form();
        requestData.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        requestData.param("client_secret", "bad_secret");
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testDuplicateClientIds() {
        ApplicationBuilder b = TEST_DATA_RESOURCE.getAdminApplication().getBuilder();
        Client c1 = b.client(ClientType.AuthorizationGrant, true).build().getClient();
        Client c2 = b.client(ClientType.AuthorizationGrant, true).build().getClient();
        Form requestData = new Form();
        requestData.param("client_id", IdUtil.toString((BigInteger)c1.getId()));
        requestData.param("client_id", IdUtil.toString((BigInteger)c2.getId()));
        requestData.param("client_secret", c1.getClientSecret());
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testDuplicateClientSecrets() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.AuthorizationGrant, true).build().getClient();
        Form requestData = new Form();
        requestData.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        requestData.param("client_secret", c.getClientSecret());
        requestData.param("client_secret", c.getClientSecret());
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testPublicClient() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.AuthorizationGrant, false).build().getClient();
        Form requestData = new Form();
        requestData.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testPublicClientNotPermitted() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.AuthorizationGrant, false).build().getClient();
        Form requestData = new Form();
        requestData.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client/private").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testPrivateClient() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.AuthorizationGrant, true).build().getClient();
        Form requestData = new Form();
        requestData.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        requestData.param("client_secret", c.getClientSecret());
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testPrivateClientNotPermitted() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.AuthorizationGrant, true).build().getClient();
        Form requestData = new Form();
        requestData.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        requestData.param("client_secret", c.getClientSecret());
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client/public").request().post(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testPUTClient() {
        Client c = TEST_DATA_RESOURCE.getAdminApplication().getBuilder().client(ClientType.AuthorizationGrant, true).build().getClient();
        Form requestData = new Form();
        requestData.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        requestData.param("client_secret", c.getClientSecret());
        Entity testEntity = Entity.entity((Object)requestData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/client").request().put(testEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }
}

