/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authn;

import java.math.BigInteger;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.FirstRunContainerLifecycleListener;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.ServletConfigFactory;
import net.krotscheck.kangaroo.authz.admin.v1.test.rule.TestDataResource;
import net.krotscheck.kangaroo.authz.common.database.DatabaseFeature;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2AuthDynamicFeature;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.O2TestResource;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.config.ConfigurationFeature;
import net.krotscheck.kangaroo.common.exception.ExceptionFeature;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public final class O2BearerTokenFilterTest
extends ContainerTest {
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE);

    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(ConfigurationFeature.class);
        a.register(DatabaseFeature.class);
        a.register(ExceptionFeature.class);
        a.register((Object)new ServletConfigFactory.Binder());
        a.register((Object)new FirstRunContainerLifecycleListener.Binder());
        a.register(O2AuthDynamicFeature.class);
        a.register(O2TestResource.class);
        return a;
    }

    @Test
    public void testNoAuthorization() {
        Response r = this.target("/token").request().get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testInvalidAuthorizationHeader() {
        Response r = this.target("/token").request().header("Authorization", (Object)"Not A Valid header").get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testInvalidBearerHeader() {
        Response r = this.target("/token").request().header("Authorization", (Object)"Bearer some_secluded_rendezvous").get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testMalformedCredentialsHeader() {
        String header = HttpUtil.authHeaderBearer((String)"malformed_token");
        Response r = this.target("/token").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testNonexistentCredentialsHeader() {
        BigInteger id = IdUtil.next();
        String header = HttpUtil.authHeaderBearer((BigInteger)id);
        Response r = this.target("/token").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testBadPasswordHeader() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, true).build();
        Client c = context.getClient();
        String header = HttpUtil.authHeaderBearer((BigInteger)c.getId());
        Response r = this.target("/token").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testPublicClientHeader() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, false).build();
        Client c = context.getClient();
        String header = HttpUtil.authHeaderBearer((BigInteger)c.getId());
        Response r = this.target("/token").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testValidRequestHeaderPrivate() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, true).bearerToken().build();
        OAuthToken t = context.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)t.getId());
        Response r = this.target("/token/private").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testValidRequestHeaderPrivateNotPermitted() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, true).bearerToken().build();
        OAuthToken t = context.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)t.getId());
        Response r = this.target("/token/public").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testValidRequestHeaderPublic() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, false).bearerToken().build();
        OAuthToken t = context.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)t.getId());
        Response r = this.target("/token/public").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testValidRequestHeaderPublicNotPermitted() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.Implicit, false).bearerToken().build();
        OAuthToken t = context.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)t.getId());
        Response r = this.target("/token/private").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testExpiredToken() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, true).token(OAuthTokenType.Bearer, true, null, null, null).build();
        OAuthToken t = context.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)t.getId());
        Response r = this.target("/token/private").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testRefreshToken() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, true).bearerToken().refreshToken().build();
        OAuthToken t = context.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)t.getId());
        Response r = this.target("/token/private").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testAuthorizationCode() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, true).authToken().build();
        OAuthToken t = context.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)t.getId());
        Response r = this.target("/token/private").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }
}

