/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authn;

import java.math.BigInteger;
import java.util.AbstractMap;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2SecurityContext;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.AbstractO2AuthenticationFilter;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.glassfish.jersey.server.ContainerRequest;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public final class AbstractO2AuthenticationFilterTest {
    private AbstractO2AuthenticationFilter testFilter;
    private ContainerRequest mockContainerRequest;
    private Session mockSession;
    private SecurityContext mockSecurityContext;

    @Before
    public void setup() {
        this.mockContainerRequest = (ContainerRequest)Mockito.mock(ContainerRequest.class);
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockSecurityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        ((ContainerRequest)Mockito.doReturn((Object)this.mockSecurityContext).when((Object)this.mockContainerRequest)).getSecurityContext();
        Provider requestProvider = () -> this.mockContainerRequest;
        Provider sessionProvider = () -> this.mockSession;
        this.testFilter = new AbstractO2AuthenticationFilter(requestProvider, sessionProvider){

            public void filter(ContainerRequestContext requestContext) {
            }
        };
    }

    @Test
    public void getSession() {
        Assert.assertSame((Object)this.mockSession, (Object)this.testFilter.getSession());
        Assert.assertSame((Object)this.mockContainerRequest, (Object)this.testFilter.getRequest());
        Assert.assertSame((Object)this.mockSecurityContext, (Object)this.testFilter.getSecurityContext());
    }

    @Test
    public void setPrincipal() {
        ArgumentCaptor scCaptor = ArgumentCaptor.forClass(SecurityContext.class);
        this.mockContainerRequest = (ContainerRequest)Mockito.spy((Object)this.mockContainerRequest);
        Client c = new Client();
        c.setId(IdUtil.next());
        c.setClientSecret("secret");
        O2Principal p = new O2Principal(c);
        Assert.assertFalse((boolean)(this.testFilter.getSecurityContext() instanceof O2SecurityContext));
        this.testFilter.setPrincipal(p);
        ((ContainerRequest)Mockito.verify((Object)this.mockContainerRequest)).setSecurityContext((SecurityContext)scCaptor.capture());
        SecurityContext setContext = (SecurityContext)scCaptor.getValue();
        Assert.assertNotNull((Object)setContext);
        Assert.assertTrue((boolean)(setContext instanceof O2SecurityContext));
        O2Principal setPrincipal = (O2Principal)setContext.getUserPrincipal();
        Assert.assertEquals((Object)p, (Object)setPrincipal);
    }

    @Test
    public void convertCredentials() {
        BigInteger validId = IdUtil.next();
        String validRawId = IdUtil.toString((BigInteger)validId);
        Assert.assertNull((Object)this.testFilter.convertCredentials(null, "secret"));
        Assert.assertNull((Object)this.testFilter.convertCredentials("malformed", "secret"));
        Assert.assertEquals(new AbstractMap.SimpleEntry<BigInteger, String>(validId, "secret"), (Object)this.testFilter.convertCredentials(validRawId, "secret"));
        Assert.assertEquals(new AbstractMap.SimpleEntry<BigInteger, Object>(validId, null), (Object)this.testFilter.convertCredentials(validRawId, null));
        Assert.assertEquals(new AbstractMap.SimpleEntry<BigInteger, Object>(validId, null), (Object)this.testFilter.convertCredentials(validRawId, ""));
    }
}

