/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn;

import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2AuthScheme;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2SecurityContext;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.junit.Assert;
import org.junit.Test;

public final class O2SecurityContextTest {
    @Test
    public void getUserPrincipal() {
        O2Principal p = new O2Principal();
        O2SecurityContext context = new O2SecurityContext(p);
        Assert.assertSame((Object)p, (Object)context.getUserPrincipal());
    }

    @Test
    public void isUserInRole() {
        O2Principal p = new O2Principal();
        O2SecurityContext context = new O2SecurityContext(p);
        Assert.assertFalse((boolean)context.isUserInRole("some_random_role"));
    }

    @Test
    public void isSecure() {
        O2Principal p = new O2Principal();
        O2SecurityContext context = new O2SecurityContext(p);
        Assert.assertTrue((boolean)context.isSecure());
    }

    @Test
    public void getAuthenticationScheme() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        c1.setClientSecret("secret");
        O2Principal p1 = new O2Principal(c1);
        O2SecurityContext context1 = new O2SecurityContext(p1);
        Assert.assertEquals((Object)O2AuthScheme.ClientPrivate.toString(), (Object)context1.getAuthenticationScheme());
        Client c2 = new Client();
        c2.setId(IdUtil.next());
        O2Principal p2 = new O2Principal(c2);
        O2SecurityContext context2 = new O2SecurityContext(p2);
        Assert.assertEquals((Object)O2AuthScheme.ClientPublic.toString(), (Object)context2.getAuthenticationScheme());
        O2Principal p3 = new O2Principal();
        O2SecurityContext context3 = new O2SecurityContext(p3);
        Assert.assertEquals((Object)O2AuthScheme.None.toString(), (Object)context3.getAuthenticationScheme());
    }
}

