/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn;

import java.math.BigInteger;
import java.security.Principal;
import javax.security.auth.Subject;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2AuthScheme;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class O2PrincipalTest {
    @Test
    public void testDefaultConstructor() {
        O2Principal p = new O2Principal();
        Assert.assertEquals((Object)O2AuthScheme.None.toString(), (Object)p.getScheme());
        Assert.assertNull((Object)p.getName());
        Assert.assertFalse((boolean)p.implies((Subject)Mockito.mock(Subject.class)));
        Assert.assertNull((Object)p.getContext());
        Assert.assertNull((Object)p.getOAuthToken());
    }

    @Test
    public void testConstructorPublicClient() {
        Client testClient = new Client();
        testClient.setId(IdUtil.next());
        testClient.setClientSecret(null);
        testClient.setName("Test client");
        O2Principal p = new O2Principal(testClient);
        Assert.assertEquals((Object)O2AuthScheme.ClientPublic.toString(), (Object)p.getScheme());
        Assert.assertEquals((Object)testClient.getName(), (Object)p.getName());
        Assert.assertFalse((boolean)p.implies((Subject)Mockito.mock(Subject.class)));
        Assert.assertEquals((Object)testClient, (Object)p.getContext());
        Assert.assertNull((Object)p.getOAuthToken());
    }

    @Test
    public void testConstructorPrivateClient() {
        Client testClient = new Client();
        testClient.setId(IdUtil.next());
        testClient.setClientSecret(IdUtil.toString((BigInteger)IdUtil.next()));
        testClient.setName("Test client");
        O2Principal p = new O2Principal(testClient);
        Assert.assertEquals((Object)O2AuthScheme.ClientPrivate.toString(), (Object)p.getScheme());
        Assert.assertEquals((Object)testClient.getName(), (Object)p.getName());
        Assert.assertFalse((boolean)p.implies((Subject)Mockito.mock(Subject.class)));
        Assert.assertEquals((Object)testClient, (Object)p.getContext());
        Assert.assertNull((Object)p.getOAuthToken());
    }

    @Test
    public void testConstructorNullClient() {
        O2Principal p = new O2Principal((Client)null);
        Assert.assertEquals((Object)O2AuthScheme.None.toString(), (Object)p.getScheme());
        Assert.assertNull((Object)p.getName());
        Assert.assertFalse((boolean)p.implies((Subject)Mockito.mock(Subject.class)));
        Assert.assertNull((Object)p.getContext());
        Assert.assertNull((Object)p.getOAuthToken());
    }

    @Test
    public void testConstructorInvalidClient() {
        Client testClient = new Client();
        O2Principal p = new O2Principal(testClient);
        Assert.assertEquals((Object)O2AuthScheme.None.toString(), (Object)p.getScheme());
        Assert.assertNull((Object)p.getName());
        Assert.assertFalse((boolean)p.implies((Subject)Mockito.mock(Subject.class)));
        Assert.assertNull((Object)p.getContext());
        Assert.assertNull((Object)p.getOAuthToken());
    }

    @Test
    public void testConstructorToken() {
        Client c = new Client();
        c.setId(IdUtil.next());
        OAuthToken t = new OAuthToken();
        t.setTokenType(OAuthTokenType.Bearer);
        t.setId(IdUtil.next());
        t.setClient(c);
        O2Principal p = new O2Principal(t);
        Assert.assertEquals((Object)O2AuthScheme.BearerToken.toString(), (Object)p.getScheme());
        Assert.assertNull((Object)p.getName());
        Assert.assertFalse((boolean)p.implies((Subject)Mockito.mock(Subject.class)));
        Assert.assertEquals((Object)c, (Object)p.getContext());
        Assert.assertEquals((Object)t, (Object)p.getOAuthToken());
    }

    @Test
    public void testConstructorInvalidToken() {
        OAuthToken t = new OAuthToken();
        t.setTokenType(OAuthTokenType.Bearer);
        O2Principal p = new O2Principal(t);
        Assert.assertEquals((Object)O2AuthScheme.None.toString(), (Object)p.getScheme());
        Assert.assertNull((Object)p.getName());
        Assert.assertFalse((boolean)p.implies((Subject)Mockito.mock(Subject.class)));
        Assert.assertNull((Object)p.getContext());
        Assert.assertNull((Object)p.getOAuthToken());
    }

    @Test
    public void testSameOrOne() {
        O2Principal p = new O2Principal();
        Client left = new Client();
        left.setId(IdUtil.next());
        Client right = new Client();
        right.setId(left.getId());
        Assert.assertEquals((Object)left, (Object)p.sameOrOne((AbstractEntity)left, null));
        Assert.assertEquals((Object)right, (Object)p.sameOrOne(null, (AbstractEntity)right));
        Assert.assertEquals((Object)left, (Object)p.sameOrOne((AbstractEntity)left, (AbstractEntity)right));
    }

    @Test(expected=RFC6749.AccessDeniedException.class)
    public void testSameOrOneFail() {
        O2Principal p = new O2Principal();
        Client left = new Client();
        left.setId(IdUtil.next());
        Client right = new Client();
        right.setId(IdUtil.next());
        p.sameOrOne((AbstractEntity)left, (AbstractEntity)right);
    }

    @Test
    public void testMergeNullInput() {
        Client c = new Client();
        c.setId(IdUtil.next());
        O2Principal principal = new O2Principal(c);
        O2Principal merged = principal.merge(null);
        Assert.assertEquals((Object)principal, (Object)merged);
        Assert.assertNotSame((Object)principal, (Object)merged);
    }

    @Test
    public void testMergeWrongPrincipalInput() {
        Client c = new Client();
        c.setId(IdUtil.next());
        O2Principal principal = new O2Principal(c);
        Principal mergeable = () -> null;
        O2Principal merged = principal.merge(mergeable);
        Assert.assertEquals((Object)principal, (Object)merged);
        Assert.assertNotSame((Object)principal, (Object)merged);
    }

    @Test(expected=RFC6749.AccessDeniedException.class)
    public void testMergeMismatchClient() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        O2Principal p1 = new O2Principal(c1);
        Client c2 = new Client();
        c2.setId(IdUtil.next());
        O2Principal p2 = new O2Principal(c2);
        p1.merge((Principal)p2);
    }

    @Test(expected=RFC6749.AccessDeniedException.class)
    public void testMergeTwoAuthSchemes() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        c1.setClientSecret("foo");
        O2Principal p1 = new O2Principal(c1);
        Client c2 = new Client();
        c2.setId(c1.getId());
        O2Principal p2 = new O2Principal(c2);
        p1.merge((Principal)p2);
    }

    @Test
    public void testMergeSameAuthScheme() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        c1.setClientSecret("secret");
        O2Principal p1 = new O2Principal(c1);
        Client c2 = new Client();
        c2.setId(c1.getId());
        c2.setClientSecret("secret");
        O2Principal p2 = new O2Principal(c2);
        O2Principal merged = p1.merge((Principal)p2);
        Assert.assertEquals((Object)p1, (Object)merged);
        Assert.assertEquals((Object)p2, (Object)merged);
        Assert.assertNotSame((Object)p1, (Object)merged);
        Assert.assertNotSame((Object)p2, (Object)merged);
    }

    @Test
    public void testMergeNoAuthSchemePrivate() {
        Client c = new Client();
        c.setId(IdUtil.next());
        c.setClientSecret("secret");
        O2Principal p1 = new O2Principal(c);
        O2Principal p2 = new O2Principal();
        O2Principal merged = p1.merge((Principal)p2);
        Assert.assertEquals((Object)p1, (Object)merged);
        Assert.assertNotSame((Object)p1, (Object)merged);
    }

    @Test
    public void testMergeNoAuthScheme() {
        O2Principal p1 = new O2Principal();
        O2Principal p2 = new O2Principal();
        O2Principal merged = p1.merge((Principal)p2);
        Assert.assertEquals((Object)p1, (Object)merged);
        Assert.assertNotSame((Object)p1, (Object)merged);
        O2Principal mergedReverse = p2.merge((Principal)p1);
        Assert.assertEquals((Object)p1, (Object)mergedReverse);
        Assert.assertNotSame((Object)p1, (Object)mergedReverse);
    }

    @Test(expected=RFC6749.AccessDeniedException.class)
    public void testMergeTokenAndClient() {
        Client c = new Client();
        c.setId(IdUtil.next());
        c.setClientSecret("secret");
        O2Principal p1 = new O2Principal(c);
        OAuthToken t = new OAuthToken();
        t.setId(IdUtil.next());
        t.setClient(c);
        O2Principal p2 = new O2Principal(t);
        p1.merge((Principal)p2);
    }

    @Test(expected=RFC6749.AccessDeniedException.class)
    public void testMergeTwoDifferentTokens() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        c1.setClientSecret("secret");
        OAuthToken t1 = new OAuthToken();
        t1.setId(IdUtil.next());
        t1.setClient(c1);
        O2Principal p1 = new O2Principal(t1);
        Client c2 = new Client();
        c2.setId(IdUtil.next());
        c2.setClientSecret("secret");
        OAuthToken t2 = new OAuthToken();
        t2.setId(IdUtil.next());
        t2.setClient(c2);
        O2Principal p2 = new O2Principal(t2);
        p1.merge((Principal)p2);
    }

    @Test
    public void testMergeTwoTokens() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        c1.setClientSecret("secret");
        OAuthToken t = new OAuthToken();
        t.setId(IdUtil.next());
        t.setClient(c1);
        O2Principal p1 = new O2Principal(t);
        O2Principal p2 = new O2Principal(t);
        O2Principal p = p1.merge((Principal)p2);
        Assert.assertEquals((Object)p, (Object)p1);
        Assert.assertEquals((Object)p, (Object)p2);
    }

    @Test
    public void testMergeTokenAndNull() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        c1.setClientSecret("secret");
        OAuthToken t = new OAuthToken();
        t.setId(IdUtil.next());
        t.setClient(c1);
        O2Principal p1 = new O2Principal(t);
        O2Principal merged = p1.merge(null);
        Assert.assertEquals((Object)p1, (Object)merged);
        Assert.assertNotSame((Object)p1, (Object)merged);
    }

    @Test
    public void testMergeTokenAndEmpty() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        c1.setClientSecret("secret");
        OAuthToken t = new OAuthToken();
        t.setId(IdUtil.next());
        t.setClient(c1);
        O2Principal p1 = new O2Principal(t);
        O2Principal p2 = new O2Principal();
        O2Principal merged = p1.merge((Principal)p2);
        Assert.assertEquals((Object)p1, (Object)merged);
        Assert.assertNotEquals((Object)p2, (Object)merged);
        Assert.assertNotSame((Object)p1, (Object)merged);
    }

    @Test
    public void testEquality() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        c1.setClientSecret("secret");
        OAuthToken t1 = new OAuthToken();
        t1.setId(IdUtil.next());
        t1.setClient(c1);
        O2Principal p1 = new O2Principal(c1);
        O2Principal pSame = new O2Principal(c1);
        O2Principal p1Token = new O2Principal(t1);
        Client c2 = new Client();
        c2.setId(IdUtil.next());
        OAuthToken t2 = new OAuthToken();
        t2.setId(IdUtil.next());
        t2.setClient(c2);
        O2Principal p2 = new O2Principal(c2);
        O2Principal p2Token = new O2Principal(t2);
        Client c3 = new Client();
        c3.setId(IdUtil.next());
        O2Principal p3 = new O2Principal(c3);
        Assert.assertFalse((boolean)p1.equals(new Object()));
        Assert.assertFalse((boolean)p1.equals(null));
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p1.equals((Object)p3));
        Assert.assertFalse((boolean)p2.equals((Object)p3));
        Assert.assertFalse((boolean)p1.equals((Object)p1Token));
        Assert.assertFalse((boolean)p2.equals((Object)p2Token));
        Assert.assertFalse((boolean)p1Token.equals((Object)p2Token));
        Assert.assertTrue((boolean)p1.equals((Object)p1));
        Assert.assertTrue((boolean)p1.equals((Object)pSame));
    }

    @Test
    public void testHashCode() {
        Client c1 = new Client();
        c1.setId(IdUtil.next());
        c1.setClientSecret("secret");
        O2Principal p1 = new O2Principal(c1);
        Client cSame = new Client();
        cSame.setId(c1.getId());
        cSame.setClientSecret(c1.getClientSecret());
        O2Principal pSame = new O2Principal(cSame);
        Client c2 = new Client();
        c2.setId(IdUtil.next());
        c2.setClientSecret("other_secret");
        O2Principal p2 = new O2Principal(c2);
        Assert.assertEquals((long)p1.hashCode(), (long)pSame.hashCode());
        Assert.assertNotEquals((long)p1.hashCode(), (long)p2.hashCode());
        Assert.assertNotEquals((long)pSame.hashCode(), (long)p2.hashCode());
    }
}

