/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2AuthScheme;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;

public final class O2AuthSchemeTest {
    @Test
    public void testSerialization() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        String auth = m.writeValueAsString((Object)O2AuthScheme.ClientPrivate);
        Assert.assertEquals((Object)"\"ClientPrivate\"", (Object)auth);
        String implicit = m.writeValueAsString((Object)O2AuthScheme.ClientPublic);
        Assert.assertEquals((Object)"\"ClientPublic\"", (Object)implicit);
        String bearerToken = m.writeValueAsString((Object)O2AuthScheme.BearerToken);
        Assert.assertEquals((Object)"\"BearerToken\"", (Object)bearerToken);
        String owner = m.writeValueAsString((Object)O2AuthScheme.None);
        Assert.assertEquals((Object)"\"None\"", (Object)owner);
    }

    @Test
    public void testDeserialization() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        O2AuthScheme auth = (O2AuthScheme)m.readValue("\"ClientPrivate\"", O2AuthScheme.class);
        Assert.assertSame((Object)auth, (Object)O2AuthScheme.ClientPrivate);
        O2AuthScheme implicit = (O2AuthScheme)m.readValue("\"ClientPublic\"", O2AuthScheme.class);
        Assert.assertSame((Object)implicit, (Object)O2AuthScheme.ClientPublic);
        O2AuthScheme bearerToken = (O2AuthScheme)m.readValue("\"BearerToken\"", O2AuthScheme.class);
        Assert.assertSame((Object)bearerToken, (Object)O2AuthScheme.BearerToken);
        O2AuthScheme owner = (O2AuthScheme)m.readValue("\"None\"", O2AuthScheme.class);
        Assert.assertSame((Object)owner, (Object)O2AuthScheme.None);
    }

    @Test
    public void testValueOf() {
        Assert.assertEquals((Object)O2AuthScheme.ClientPrivate, (Object)O2AuthScheme.valueOf((String)"ClientPrivate"));
        Assert.assertEquals((Object)O2AuthScheme.ClientPublic, (Object)O2AuthScheme.valueOf((String)"ClientPublic"));
        Assert.assertEquals((Object)O2AuthScheme.BearerToken, (Object)O2AuthScheme.valueOf((String)"BearerToken"));
        Assert.assertEquals((Object)O2AuthScheme.None, (Object)O2AuthScheme.valueOf((String)"None"));
    }

    @Test
    public void testType() {
        Assert.assertTrue((boolean)O2AuthScheme.ClientPrivate.isAuth());
        Assert.assertTrue((boolean)O2AuthScheme.BearerToken.isAuth());
        Assert.assertFalse((boolean)O2AuthScheme.ClientPublic.isAuth());
        Assert.assertFalse((boolean)O2AuthScheme.None.isAuth());
    }
}

