/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn;

import java.math.BigInteger;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.FirstRunContainerLifecycleListener;
import net.krotscheck.kangaroo.authz.admin.v1.servlet.ServletConfigFactory;
import net.krotscheck.kangaroo.authz.admin.v1.test.rule.TestDataResource;
import net.krotscheck.kangaroo.authz.common.database.DatabaseFeature;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2AuthDynamicFeature;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.O2TestResource;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.config.ConfigurationFeature;
import net.krotscheck.kangaroo.common.exception.ExceptionFeature;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public final class O2AuthDynamicFeatureTest
extends ContainerTest {
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE);

    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(ConfigurationFeature.class);
        a.register(DatabaseFeature.class);
        a.register(ExceptionFeature.class);
        a.register((Object)new ServletConfigFactory.Binder());
        a.register((Object)new FirstRunContainerLifecycleListener.Binder());
        a.register(O2AuthDynamicFeature.class);
        a.register(O2TestResource.class);
        return a;
    }

    @Test
    public void testFailedAuth() {
        Response r = this.target("/client").request().get();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testValidClientAuth() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, true).build();
        Client c = context.getClient();
        String header = HttpUtil.authHeaderBasic((BigInteger)c.getId(), (String)c.getClientSecret());
        Response r = this.target("/client").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testValidTokenAuth() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getSecondaryApplication().getBuilder().client(ClientType.AuthorizationGrant, true).bearerToken().build();
        OAuthToken t = context.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)t.getId());
        Response r = this.target("/token").request().header("Authorization", (Object)header).get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }
}

