/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TreeMap;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.util.ValidationUtil;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ValidationUtilTest {
    private SortedMap<String, ApplicationScope> validScopes;
    private SortedMap<String, ApplicationScope> emptyScope = new TreeMap<String, ApplicationScope>();

    @Before
    public void setupTest() {
        this.validScopes = new TreeMap<String, ApplicationScope>();
        this.validScopes.put("debug", new ApplicationScope());
        this.validScopes.put("debug1", new ApplicationScope());
        this.validScopes.put("encodable:scope", new ApplicationScope());
    }

    @Test
    public void testPrivateConstructor() throws Exception {
        Constructor c = ValidationUtil.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(c.getModifiers()));
        c.setAccessible(true);
        c.newInstance(new Object[0]);
    }

    @Test
    public void testValidateClientRedirects() throws Exception {
        ArrayList<ClientRedirect> testRedirects = new ArrayList<ClientRedirect>();
        ClientRedirect redirect1 = new ClientRedirect();
        redirect1.setUri(new URI("http://one.example.com"));
        testRedirects.add(redirect1);
        ClientRedirect redirect2 = new ClientRedirect();
        redirect2.setUri(new URI("http://two.example.com"));
        testRedirects.add(redirect2);
        URI result = ValidationUtil.requireValidRedirect((String)"http://one.example.com", testRedirects);
        Assert.assertEquals((Object)"http://one.example.com", (Object)result.toString());
    }

    @Test
    public void testValidateClientRedirectsWithUri() throws Exception {
        ArrayList<ClientRedirect> testRedirects = new ArrayList<ClientRedirect>();
        ClientRedirect redirect1 = new ClientRedirect();
        redirect1.setUri(new URI("http://one.example.com"));
        testRedirects.add(redirect1);
        ClientRedirect redirect2 = new ClientRedirect();
        redirect2.setUri(new URI("http://two.example.com"));
        testRedirects.add(redirect2);
        URI validUri = URI.create("http://two.example.com");
        URI result = ValidationUtil.requireValidRedirect((URI)validUri, testRedirects);
        Assert.assertEquals((Object)validUri, (Object)result);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testValidateClientRedirectsWithNullUri() throws Exception {
        ArrayList<ClientRedirect> testRedirects = new ArrayList<ClientRedirect>();
        ClientRedirect redirect1 = new ClientRedirect();
        redirect1.setUri(new URI("http://one.example.com"));
        testRedirects.add(redirect1);
        ClientRedirect redirect2 = new ClientRedirect();
        redirect2.setUri(new URI("http://two.example.com"));
        testRedirects.add(redirect2);
        ValidationUtil.requireValidRedirect((URI)null, testRedirects);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testValidateClientRedirectsWithNullString() throws Exception {
        ArrayList<ClientRedirect> testRedirects = new ArrayList<ClientRedirect>();
        ClientRedirect redirect1 = new ClientRedirect();
        redirect1.setUri(new URI("http://one.example.com"));
        testRedirects.add(redirect1);
        ClientRedirect redirect2 = new ClientRedirect();
        redirect2.setUri(new URI("http://two.example.com"));
        testRedirects.add(redirect2);
        URI result = ValidationUtil.requireValidRedirect((String)null, testRedirects);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testValidateRedirect() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com"));
        testSet.add(new URI("http://two.example.com"));
        URI result = ValidationUtil.requireValidRedirect((String)"http://one.example.com", testSet);
        Assert.assertEquals((Object)"http://one.example.com", (Object)result.toString());
    }

    @Test
    public void testValidateUriRedirect() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com"));
        testSet.add(new URI("http://two.example.com"));
        URI result = ValidationUtil.validateRedirect((URI)new URI("http://one.example.com"), testSet);
        Assert.assertEquals((Object)"http://one.example.com", (Object)result.toString());
    }

    @Test
    public void testValidateNullUriRedirect() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com"));
        testSet.add(new URI("http://two.example.com"));
        URI result = ValidationUtil.validateRedirect((URI)null, testSet);
        Assert.assertNull((Object)result);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testInvalidRedirectHost() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com"));
        testSet.add(new URI("http://two.example.com"));
        ValidationUtil.requireValidRedirect((String)"http://three.example.com", testSet);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testInvalidRedirectPort() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com:800"));
        testSet.add(new URI("http://two.example.com:800"));
        ValidationUtil.requireValidRedirect((String)"http://one.example.com:900", testSet);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testInvalidRedirectScheme() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("https://one.example.com"));
        ValidationUtil.requireValidRedirect((String)"http://one.example.com", testSet);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testInvalidRedirectPath() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com/foo"));
        ValidationUtil.requireValidRedirect((String)"http://one.example.com/bar", testSet);
    }

    @Test
    public void testInvalidClientRedirects() throws Exception {
        ArrayList<ClientRedirect> testRedirects = new ArrayList<ClientRedirect>();
        ClientRedirect redirect1 = new ClientRedirect();
        redirect1.setUri(new URI("http://one.example.com"));
        testRedirects.add(redirect1);
        ClientRedirect redirect2 = new ClientRedirect();
        redirect2.setUri(new URI("http://two.example.com"));
        testRedirects.add(redirect2);
        URI result = ValidationUtil.validateRedirect((String)"http://three.example.com", testRedirects);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testValidateRedirectDefault() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://two.example.com"));
        URI result = ValidationUtil.requireValidRedirect((String)"", testSet);
        Assert.assertEquals((Object)"http://two.example.com", (Object)result.toString());
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testValidateRedirectDefaultTooMany() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com"));
        testSet.add(new URI("http://two.example.com"));
        ValidationUtil.requireValidRedirect((String)"", testSet);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testValidateRedirectNoOptions() throws Exception {
        ValidationUtil.requireValidRedirect((String)"http://two.example.com", new HashSet());
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testValidateRedirectMalformed() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://two.example.com"));
        ValidationUtil.requireValidRedirect((String)"http:\\", testSet);
    }

    @Test
    public void testValidateRedirectCustomQueryParams() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com/"));
        testSet.add(new URI("http://two.example.com/"));
        URI test = new URI("http://two.example.com/?foo=bar");
        URI result = ValidationUtil.requireValidRedirect((String)test.toString(), testSet);
        Assert.assertEquals((Object)test, (Object)result);
    }

    @Test
    public void testValidateRedirectAdditionalQueryParams() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com/?foo=bar"));
        URI test = new URI("http://one.example.com/?foo=bar&lol=cat");
        URI result = ValidationUtil.requireValidRedirect((String)test.toString(), testSet);
        Assert.assertEquals((Object)test, (Object)result);
    }

    @Test
    public void testValidateRedirectMultipleQueryParams() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com/?foo=bar&foo=cat"));
        URI test = new URI("http://one.example.com/?foo=bar&foo=cat&lol=cat");
        URI result = ValidationUtil.requireValidRedirect((String)test.toString(), testSet);
        Assert.assertEquals((Object)test, (Object)result);
    }

    @Test
    public void testValidateRedirectMultipleQueryParamsOverlap() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com/?foo=bar"));
        URI test = new URI("http://one.example.com/?foo=bar&foo=dice&lol=cat");
        URI result = ValidationUtil.requireValidRedirect((String)test.toString(), testSet);
        Assert.assertEquals((Object)test, (Object)result);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testValidateRedirectConflictingQueryParams() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com/?foo=bar"));
        URI test = new URI("http://one.example.com/?foo=cat");
        ValidationUtil.requireValidRedirect((String)test.toString(), testSet);
    }

    @Test
    public void testValidateRedirectConflictingMultiParams() throws Exception {
        HashSet<URI> testSet = new HashSet<URI>();
        testSet.add(new URI("http://one.example.com/?foo=cat"));
        testSet.add(new URI("http://one.example.com/?foo=bar"));
        URI test = new URI("http://one.example.com/?foo=bar");
        URI result = ValidationUtil.requireValidRedirect((String)test.toString(), testSet);
        Assert.assertEquals((Object)test, (Object)result);
    }

    @Test
    public void testValidScopeString() throws Exception {
        SortedMap scopes = ValidationUtil.validateScope((String)"debug1", this.validScopes);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test
    public void testEncodedValidScopeString() throws Exception {
        String scope = "encodable:scope";
        String encoded = URLEncoder.encode(scope, "UTF-8");
        SortedMap scopes = ValidationUtil.validateScope((String)encoded, this.validScopes);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test
    public void testValidScopeArray() throws Exception {
        SortedMap scopes = ValidationUtil.validateScope((String[])new String[]{"debug1"}, this.validScopes);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test
    public void testInvalidScope() throws Exception {
        SortedMap scopes = ValidationUtil.validateScope((String[])new String[]{"invalid"}, this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testNullScopeString() throws Exception {
        SortedMap scopes = ValidationUtil.validateScope((String)null, this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testEmptyScopeString() throws Exception {
        SortedMap scopes = ValidationUtil.validateScope((String)"", this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testNullScopeArray() throws Exception {
        SortedMap scopes = ValidationUtil.validateScope((String[])null, this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testEmptyScopeArray() throws Exception {
        SortedMap scopes = ValidationUtil.validateScope((String[])new String[0], this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testNullValidScopes() throws Exception {
        SortedMap scopes = ValidationUtil.validateScope((String[])new String[]{"debug1"}, null);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testEmptyValidScopes() throws Exception {
        SortedMap scopes = ValidationUtil.validateScope((String[])new String[]{"debug1"}, new TreeMap());
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testValidateScopeStringNullRole() throws Exception {
        ValidationUtil.validateScope((String)"debug1", (Role)null);
    }

    @Test
    public void testValidateScopeStringNoScopeRole() throws Exception {
        TreeMap roleScopes = new TreeMap();
        Role r = new Role();
        r.setScopes(roleScopes);
        SortedMap scopes = ValidationUtil.validateScope((String)"", (Role)r);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testValidateScopeStringValidScopesInRole() throws Exception {
        TreeMap<String, ApplicationScope> roleScopes = new TreeMap<String, ApplicationScope>();
        ApplicationScope debug1Scope = new ApplicationScope();
        debug1Scope.setName("debug1");
        roleScopes.put(debug1Scope.getName(), debug1Scope);
        ApplicationScope debug2Scope = new ApplicationScope();
        debug2Scope.setName("debug2");
        roleScopes.put(debug2Scope.getName(), debug2Scope);
        Role r = new Role();
        r.setScopes(roleScopes);
        SortedMap scopes = ValidationUtil.validateScope((String)"debug2", (Role)r);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test
    public void testValidateScopeStringMismatchScopesInRole() throws Exception {
        TreeMap<String, ApplicationScope> roleScopes = new TreeMap<String, ApplicationScope>();
        ApplicationScope debug1Scope = new ApplicationScope();
        debug1Scope.setName("debug1");
        roleScopes.put(debug1Scope.getName(), debug1Scope);
        ApplicationScope debug2Scope = new ApplicationScope();
        debug2Scope.setName("debug2");
        roleScopes.put(debug2Scope.getName(), debug2Scope);
        Role r = new Role();
        r.setScopes(roleScopes);
        SortedMap scopes = ValidationUtil.validateScope((String)"debug1 debug3", (Role)r);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testValidateScopeMapNullRole() throws Exception {
        ValidationUtil.validateScope(new TreeMap(), (Role)null);
    }

    @Test
    public void testValidateScopeMapNoScopeRole() throws Exception {
        TreeMap roleScopes = new TreeMap();
        Role r = new Role();
        r.setScopes(roleScopes);
        SortedMap scopes = ValidationUtil.validateScope(new TreeMap(), (Role)r);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testValidateScopeMapValidScopesInRole() throws Exception {
        TreeMap<String, ApplicationScope> roleScopes = new TreeMap<String, ApplicationScope>();
        ApplicationScope debug1Scope = new ApplicationScope();
        debug1Scope.setName("debug1");
        roleScopes.put(debug1Scope.getName(), debug1Scope);
        ApplicationScope debug2Scope = new ApplicationScope();
        debug2Scope.setName("debug2");
        roleScopes.put(debug2Scope.getName(), debug2Scope);
        TreeMap<String, ApplicationScope> requestedScopes = new TreeMap<String, ApplicationScope>();
        requestedScopes.put(debug2Scope.getName(), debug2Scope);
        Role r = new Role();
        r.setScopes(roleScopes);
        SortedMap scopes = ValidationUtil.validateScope(requestedScopes, (Role)r);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testValidateScopeMapMismatchScopesInRole() throws Exception {
        TreeMap<String, ApplicationScope> roleScopes = new TreeMap<String, ApplicationScope>();
        ApplicationScope debug1Scope = new ApplicationScope();
        debug1Scope.setName("debug1");
        roleScopes.put(debug1Scope.getName(), debug1Scope);
        ApplicationScope debug2Scope = new ApplicationScope();
        debug2Scope.setName("debug2");
        roleScopes.put(debug2Scope.getName(), debug2Scope);
        ApplicationScope debug3Scope = new ApplicationScope();
        debug3Scope.setName("debug3");
        TreeMap<String, ApplicationScope> requestedScopes = new TreeMap<String, ApplicationScope>();
        requestedScopes.put(debug2Scope.getName(), debug2Scope);
        requestedScopes.put(debug3Scope.getName(), debug3Scope);
        Role r = new Role();
        r.setScopes(roleScopes);
        ValidationUtil.validateScope(requestedScopes, (Role)r);
    }

    @Test
    public void testRevalidateRequestArray() throws Exception {
        SortedMap scopes = ValidationUtil.revalidateScope((String[])new String[]{"debug1"}, this.validScopes, this.validScopes);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test
    public void testRevalidateRequestString() throws Exception {
        SortedMap scopes = ValidationUtil.revalidateScope((String)"debug1", this.validScopes, this.validScopes);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test
    public void testRevalidateRequestRole() throws Exception {
        Role r = new Role();
        r.setScopes(this.validScopes);
        SortedMap scopes = ValidationUtil.revalidateScope((String)"debug1", this.validScopes, (Role)r);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testRevalidateNullRole() throws Exception {
        ValidationUtil.revalidateScope((String)"debug1", this.validScopes, (Role)null);
    }

    @Test
    public void testRevalidateEmptyRequestString() throws Exception {
        SortedMap scopes = ValidationUtil.revalidateScope((String)"", this.validScopes, this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testRevalidateNullRequestString() throws Exception {
        SortedMap scopes = ValidationUtil.revalidateScope((String)null, this.validScopes, this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testRevalidateEmptyRequestArray() throws Exception {
        SortedMap scopes = ValidationUtil.revalidateScope((String[])new String[0], this.validScopes, this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testRevalidateNullRequestArray() throws Exception {
        SortedMap scopes = ValidationUtil.revalidateScope((String[])null, this.validScopes, this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test
    public void testRevalidateEmptyOriginalScope() throws Exception {
        SortedMap scopes = ValidationUtil.revalidateScope((String[])new String[0], this.emptyScope, this.validScopes);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testRevalidateNullOriginalScope() throws Exception {
        ValidationUtil.revalidateScope((String[])new String[0], null, this.validScopes);
    }

    @Test
    public void testRevalidateEmptyValidScope() throws Exception {
        SortedMap scopes = ValidationUtil.revalidateScope((String[])new String[0], this.validScopes, this.emptyScope);
        Assert.assertEquals((long)0L, (long)scopes.size());
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testRevalidateNullValidScope() throws Exception {
        ValidationUtil.revalidateScope((String[])new String[]{"debug"}, this.validScopes, null);
    }

    @Test(expected=RFC6749.InvalidScopeException.class)
    public void testRevalidateCannotEscalateRequestScope() throws Exception {
        TreeMap<String, ApplicationScope> granted = new TreeMap<String, ApplicationScope>();
        granted.put("debug1", new ApplicationScope());
        ValidationUtil.revalidateScope((String[])new String[]{"debug", "debug1"}, granted, this.validScopes);
    }

    @Test
    public void testRevalidateValidScopesShrank() throws Exception {
        TreeMap<String, ApplicationScope> shrunkScopes = new TreeMap<String, ApplicationScope>();
        shrunkScopes.put("debug1", new ApplicationScope());
        SortedMap scopes = ValidationUtil.revalidateScope((String[])new String[]{"debug", "debug1"}, this.validScopes, shrunkScopes);
        Assert.assertEquals((long)1L, (long)scopes.size());
    }

    @Test
    public void testValidateAuthenticator() throws Exception {
        ArrayList<Authenticator> testList = new ArrayList<Authenticator>();
        Authenticator one = new Authenticator();
        one.setType(AuthenticatorType.Password);
        Authenticator two = new Authenticator();
        two.setType(AuthenticatorType.Test);
        testList.add(one);
        testList.add(two);
        Authenticator result = ValidationUtil.validateAuthenticator((AuthenticatorType)AuthenticatorType.Test, testList);
        Assert.assertEquals((Object)result, (Object)two);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testInvalidAuthenticator() throws Exception {
        ArrayList<Authenticator> testList = new ArrayList<Authenticator>();
        Authenticator one = new Authenticator();
        one.setType(AuthenticatorType.Password);
        testList.add(one);
        ValidationUtil.validateAuthenticator((AuthenticatorType)AuthenticatorType.Test, testList);
    }

    @Test
    public void testValidateAuthenticatorDefault() throws Exception {
        ArrayList<Authenticator> testList = new ArrayList<Authenticator>();
        Authenticator one = new Authenticator();
        one.setType(AuthenticatorType.Password);
        testList.add(one);
        Authenticator result = ValidationUtil.validateAuthenticator(null, testList);
        Assert.assertEquals((Object)result, (Object)one);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testValidateAuthenticatorDefaultTooMany() throws Exception {
        ArrayList<Authenticator> testList = new ArrayList<Authenticator>();
        Authenticator one = new Authenticator();
        one.setType(AuthenticatorType.Password);
        Authenticator two = new Authenticator();
        one.setType(AuthenticatorType.Test);
        testList.add(one);
        testList.add(two);
        ValidationUtil.validateAuthenticator(null, testList);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testValidateAuthenticatorNoOptions() throws Exception {
        ArrayList testList = new ArrayList();
        ValidationUtil.validateAuthenticator(null, testList);
    }

    @Test
    public void testResponseTypeValidImplicitResponseType() {
        Client c = new Client();
        c.setType(ClientType.Implicit);
        ValidationUtil.validateResponseType((Client)c, (String)"token");
    }

    @Test
    public void testResponseTypeValidGrantResponseType() {
        Client c = new Client();
        c.setType(ClientType.AuthorizationGrant);
        ValidationUtil.validateResponseType((Client)c, (String)"code");
    }

    @Test(expected=RFC6749.UnsupportedResponseTypeException.class)
    public void testResponseTypeMismatchedImplicitType() {
        Client c = new Client();
        c.setType(ClientType.Implicit);
        ValidationUtil.validateResponseType((Client)c, (String)"code");
    }

    @Test(expected=RFC6749.UnsupportedResponseTypeException.class)
    public void testResponseTypeMismatchedGrantType() {
        Client c = new Client();
        c.setType(ClientType.AuthorizationGrant);
        ValidationUtil.validateResponseType((Client)c, (String)"token");
    }

    @Test(expected=RFC6749.UnsupportedResponseTypeException.class)
    public void testResponseTypeBogusType() {
        Client c = new Client();
        c.setType(ClientType.OwnerCredentials);
        ValidationUtil.validateResponseType((Client)c, (String)"code");
    }

    @Test(expected=RFC6749.UnsupportedResponseTypeException.class)
    public void testResponseTypeNullResponseType() {
        Client c = new Client();
        c.setType(ClientType.OwnerCredentials);
        ValidationUtil.validateResponseType((Client)c, null);
    }

    @Test(expected=RFC6749.UnsupportedResponseTypeException.class)
    public void testResponseTypeNullClient() {
        Client c = new Client();
        c.setType(ClientType.OwnerCredentials);
        ValidationUtil.validateResponseType(null, (String)"code");
    }
}

