/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import net.krotscheck.kangaroo.authz.common.util.PasswordUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;

public final class PasswordUtilTest {
    @Test
    public void testPrivateConstructor() throws Exception {
        Constructor c = PasswordUtil.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(c.getModifiers()));
        c.setAccessible(true);
        c.newInstance(new Object[0]);
    }

    @Test
    public void testCreateSalt() {
        String salt = PasswordUtil.createSalt();
        Assert.assertEquals((long)44L, (long)salt.length());
        String salt2 = PasswordUtil.createSalt();
        Assert.assertNotEquals((Object)salt, (Object)salt2);
    }

    @Test
    public void testHashAndValidate() throws Exception {
        String password = RandomStringUtils.random((int)40);
        String salt1 = PasswordUtil.createSalt();
        String salt2 = PasswordUtil.createSalt();
        String hash1 = PasswordUtil.hash((String)password, (String)salt1);
        Assert.assertTrue((boolean)PasswordUtil.isValid((String)password, (String)salt1, (String)hash1));
        Assert.assertFalse((boolean)PasswordUtil.isValid((String)password, (String)salt2, (String)hash1));
    }
}

