/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class UserTest {
    @Test
    public void testGetSetApplication() {
        User u = new User();
        Application a = new Application();
        Assert.assertNull((Object)u.getApplication());
        u.setApplication(a);
        Assert.assertEquals((Object)a, (Object)u.getApplication());
    }

    @Test
    public void testGetSetApplications() {
        User u = new User();
        ArrayList<Application> applications = new ArrayList<Application>();
        applications.add(new Application());
        applications.add(new Application());
        Assert.assertEquals((long)0L, (long)u.getIdentities().size());
        u.setApplications(applications);
        Assert.assertEquals(applications, (Object)u.getApplications());
        Assert.assertNotSame(applications, (Object)u.getApplications());
    }

    @Test
    public void testGetSetRole() {
        User user = new User();
        Role role = new Role();
        Assert.assertNull((Object)user.getRole());
        user.setRole(role);
        Assert.assertEquals((Object)role, (Object)user.getRole());
    }

    @Test
    public void testGetSetIdentities() {
        ArrayList<UserIdentity> identities = new ArrayList<UserIdentity>();
        identities.add(new UserIdentity());
        User user = new User();
        Assert.assertEquals((long)0L, (long)user.getIdentities().size());
        user.setIdentities(identities);
        Assert.assertEquals(identities, (Object)user.getIdentities());
        Assert.assertNotSame(identities, (Object)user.getIdentities());
    }

    @Test
    public void testGetOwner() {
        User user = new User();
        Application spy = (Application)Mockito.spy((Object)new Application());
        Assert.assertNull((Object)user.getOwner());
        user.setApplication(spy);
        user.getOwner();
        ((Application)Mockito.verify((Object)spy)).getOwner();
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        ArrayList<UserIdentity> identities = new ArrayList<UserIdentity>();
        UserIdentity identity = new UserIdentity();
        identity.setId(IdUtil.next());
        identities.add(identity);
        Role role = new Role();
        role.setId(IdUtil.next());
        Application application = new Application();
        application.setId(IdUtil.next());
        User user = new User();
        user.setId(IdUtil.next());
        user.setCreatedDate(Calendar.getInstance());
        user.setModifiedDate(Calendar.getInstance());
        user.setApplication(application);
        user.setRole(role);
        user.setIdentities(identities);
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)user);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)user.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(user.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(user.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)user.getRole().getId()), (Object)node.get("role").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)user.getApplication().getId()), (Object)node.get("application").asText());
        Assert.assertFalse((boolean)node.has("identities"));
        ArrayList names = new ArrayList();
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        Assert.assertEquals((long)5L, (long)names.size());
    }

    @Test
    public void testJacksonDeserializable() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        long timestamp = Calendar.getInstance().getTimeInMillis() / 1000L;
        ObjectNode node = m.createObjectNode();
        node.put("id", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("createdDate", timestamp);
        node.put("modifiedDate", timestamp);
        node.put("application", IdUtil.toString((BigInteger)IdUtil.next()));
        String output = m.writeValueAsString((Object)node);
        User user = (User)m.readValue(output, User.class);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)user.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(user.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(user.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)user.getApplication().getId()), (Object)node.get("application").asText());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger newId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)newId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        User.Deserializer deserializer = new User.Deserializer();
        User u = (User)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)newId, (Object)u.getId());
    }
}

