/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class UserIdentityTest {
    @Test
    public void testGetSetUser() {
        UserIdentity identity = new UserIdentity();
        User user = new User();
        Assert.assertNull((Object)identity.getUser());
        identity.setUser(user);
        Assert.assertEquals((Object)user, (Object)identity.getUser());
    }

    @Test
    public void testGetSetType() {
        UserIdentity identity = new UserIdentity();
        Assert.assertNull((Object)identity.getType());
        identity.setType(AuthenticatorType.Test);
        Assert.assertEquals((Object)AuthenticatorType.Test, (Object)identity.getType());
    }

    @Test
    public void testGetSetTokens() {
        UserIdentity identity = new UserIdentity();
        ArrayList<OAuthToken> tokens = new ArrayList<OAuthToken>();
        tokens.add(new OAuthToken());
        Assert.assertEquals((long)0L, (long)identity.getTokens().size());
        identity.setTokens(tokens);
        Assert.assertEquals(tokens, (Object)identity.getTokens());
        Assert.assertNotSame(tokens, (Object)identity.getTokens());
    }

    @Test
    public void testGetSetRemoteId() {
        UserIdentity identity = new UserIdentity();
        Assert.assertNull((Object)identity.getRemoteId());
        identity.setRemoteId("foo");
        Assert.assertEquals((Object)"foo", (Object)identity.getRemoteId());
    }

    @Test
    public void testGetSetClaims() {
        UserIdentity identity = new UserIdentity();
        HashMap claims = new HashMap();
        Assert.assertEquals((long)0L, (long)identity.getClaims().size());
        identity.setClaims(claims);
        Assert.assertEquals(claims, (Object)identity.getClaims());
        Assert.assertNotSame(claims, (Object)identity.getClaims());
    }

    @Test
    public void testGetSetSalt() {
        UserIdentity identity = new UserIdentity();
        String testString = "zomg";
        Assert.assertNull((Object)identity.getSalt());
        identity.setSalt(testString);
        Assert.assertEquals((Object)testString, (Object)identity.getSalt());
    }

    @Test
    public void testGetSetPassword() {
        UserIdentity identity = new UserIdentity();
        String testString = "zomg";
        Assert.assertNull((Object)identity.getPassword());
        identity.setPassword(testString);
        Assert.assertEquals((Object)testString, (Object)identity.getPassword());
    }

    @Test
    public void testGetOwner() {
        UserIdentity identity = new UserIdentity();
        User spy = (User)Mockito.spy((Object)new User());
        Assert.assertNull((Object)identity.getOwner());
        identity.setUser(spy);
        identity.getOwner();
        ((User)Mockito.verify((Object)spy)).getOwner();
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        User user = new User();
        user.setId(IdUtil.next());
        Authenticator authenticator = new Authenticator();
        authenticator.setType(AuthenticatorType.Test);
        authenticator.setId(IdUtil.next());
        ArrayList<OAuthToken> tokens = new ArrayList<OAuthToken>();
        OAuthToken token = new OAuthToken();
        token.setId(IdUtil.next());
        tokens.add(token);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("one", "value");
        claims.put("two", "value");
        UserIdentity identity = new UserIdentity();
        identity.setId(IdUtil.next());
        identity.setCreatedDate(Calendar.getInstance());
        identity.setModifiedDate(Calendar.getInstance());
        identity.setType(authenticator.getType());
        identity.setUser(user);
        identity.setTokens(tokens);
        identity.setClaims(claims);
        identity.setPassword("newpass");
        identity.setSalt("newsalt");
        identity.setRemoteId("remoteId");
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)identity);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)identity.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(identity.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(identity.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)identity.getType().toString(), (Object)node.get("type").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)identity.getUser().getId()), (Object)node.get("user").asText());
        Assert.assertEquals((Object)identity.getRemoteId(), (Object)node.get("remoteId").asText());
        JsonNode claimsNode = node.get("claims");
        Assert.assertEquals((Object)"value", (Object)claimsNode.get("one").asText());
        Assert.assertEquals((Object)"value", (Object)claimsNode.get("two").asText());
        Assert.assertFalse((boolean)node.has("tokens"));
        ArrayList names = new ArrayList();
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        Assert.assertEquals((long)9L, (long)names.size());
    }

    @Test
    public void testJacksonDeserializable() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        long timestamp = Calendar.getInstance().getTimeInMillis() / 1000L;
        ObjectNode node = m.createObjectNode();
        node.put("id", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("createdDate", timestamp);
        node.put("modifiedDate", timestamp);
        node.put("remoteId", "remoteId");
        node.put("authenticator", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("user", IdUtil.toString((BigInteger)IdUtil.next()));
        ObjectNode claimNode = m.createObjectNode();
        claimNode.put("one", "value");
        claimNode.put("two", "value");
        node.set("claims", (JsonNode)claimNode);
        String output = m.writeValueAsString((Object)node);
        UserIdentity a = (UserIdentity)m.readValue(output, UserIdentity.class);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(a.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(a.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)a.getRemoteId(), (Object)node.get("remoteId").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getUser().getId()), (Object)node.get("user").asText());
        Map claims = a.getClaims();
        Assert.assertEquals(claims.get("one"), (Object)claimNode.get("one").asText());
        Assert.assertEquals(claims.get("two"), (Object)claimNode.get("two").asText());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger newId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)newId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        UserIdentity.Deserializer deserializer = new UserIdentity.Deserializer();
        UserIdentity u = (UserIdentity)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)newId, (Object)u.getId());
    }
}

