/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TreeMap;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class RoleTest {
    @Test
    public void testGetSetApplication() {
        Role c = new Role();
        Application a = new Application();
        Assert.assertNull((Object)c.getApplication());
        c.setApplication(a);
        Assert.assertEquals((Object)a, (Object)c.getApplication());
    }

    @Test
    public void testGetSetName() {
        Role role = new Role();
        String name = "test";
        Assert.assertNull((Object)role.getName());
        role.setName(name);
        Assert.assertEquals((Object)name, (Object)role.getName());
    }

    @Test
    public void testGetSetUsers() {
        Role role = new Role();
        ArrayList<User> users = new ArrayList<User>();
        users.add(new User());
        Assert.assertEquals((long)0L, (long)role.getUsers().size());
        role.setUsers(users);
        Assert.assertEquals(users, (Object)role.getUsers());
        Assert.assertNotSame(users, (Object)role.getUsers());
    }

    @Test
    public void testGetSetScopes() {
        Role role = new Role();
        TreeMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();
        scopes.put("foo", new ApplicationScope());
        Assert.assertEquals((long)0L, (long)role.getScopes().size());
        role.setScopes(scopes);
        Assert.assertEquals(scopes, (Object)role.getScopes());
        Assert.assertNotSame(scopes, (Object)role.getScopes());
    }

    @Test
    public void testGetOwner() {
        Role role = new Role();
        Application spy = (Application)Mockito.spy((Object)new Application());
        Assert.assertNull((Object)role.getOwner());
        role.setApplication(spy);
        role.getOwner();
        ((Application)Mockito.verify((Object)spy)).getOwner();
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        ArrayList<User> users = new ArrayList<User>();
        User user = new User();
        user.setId(IdUtil.next());
        users.add(user);
        Application a = new Application();
        a.setId(IdUtil.next());
        Role role = new Role();
        role.setApplication(a);
        role.setId(IdUtil.next());
        role.setCreatedDate(Calendar.getInstance());
        role.setModifiedDate(Calendar.getInstance());
        role.setName("name");
        role.setUsers(users);
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)role);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)role.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(role.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(role.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)role.getApplication().getId()), (Object)node.get("application").asText());
        Assert.assertEquals((Object)role.getName(), (Object)node.get("name").asText());
        Assert.assertFalse((boolean)node.has("users"));
        ArrayList names = new ArrayList();
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        Assert.assertEquals((long)5L, (long)names.size());
    }

    @Test
    public void testJacksonDeserializable() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        long timestamp = Calendar.getInstance().getTimeInMillis() / 1000L;
        ObjectNode node = m.createObjectNode();
        node.put("id", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("createdDate", timestamp);
        node.put("modifiedDate", timestamp);
        node.put("name", "name");
        node.put("application", IdUtil.toString((BigInteger)IdUtil.next()));
        String output = m.writeValueAsString((Object)node);
        Role c = (Role)m.readValue(output, Role.class);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)c.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(c.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(c.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)c.getName(), (Object)node.get("name").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)c.getApplication().getId()), (Object)node.get("application").asText());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger newId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)newId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        Role.Deserializer deserializer = new Role.Deserializer();
        Role c = (Role)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)newId, (Object)c.getId());
    }
}

