/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;

public final class OAuthTokenTypeTest {
    @Test
    public void testSerialization() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        String authOutput = m.writeValueAsString((Object)OAuthTokenType.Authorization);
        Assert.assertEquals((Object)"\"Authorization\"", (Object)authOutput);
        String bearerOutput = m.writeValueAsString((Object)OAuthTokenType.Bearer);
        Assert.assertEquals((Object)"\"Bearer\"", (Object)bearerOutput);
        String refreshOutput = m.writeValueAsString((Object)OAuthTokenType.Refresh);
        Assert.assertEquals((Object)"\"Refresh\"", (Object)refreshOutput);
    }

    @Test
    public void testDeserialization() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        OAuthTokenType authOutput = (OAuthTokenType)m.readValue("\"Authorization\"", OAuthTokenType.class);
        Assert.assertSame((Object)authOutput, (Object)OAuthTokenType.Authorization);
        OAuthTokenType bearerOutput = (OAuthTokenType)m.readValue("\"Bearer\"", OAuthTokenType.class);
        Assert.assertSame((Object)bearerOutput, (Object)OAuthTokenType.Bearer);
        OAuthTokenType refreshOutput = (OAuthTokenType)m.readValue("\"Refresh\"", OAuthTokenType.class);
        Assert.assertSame((Object)refreshOutput, (Object)OAuthTokenType.Refresh);
    }

    @Test
    public void testValueOf() {
        Assert.assertEquals((Object)OAuthTokenType.Bearer, (Object)OAuthTokenType.valueOf((String)"Bearer"));
        Assert.assertEquals((Object)OAuthTokenType.Authorization, (Object)OAuthTokenType.valueOf((String)"Authorization"));
        Assert.assertEquals((Object)OAuthTokenType.Refresh, (Object)OAuthTokenType.valueOf((String)"Refresh"));
    }
}

