/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.TreeMap;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.HttpSession;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class OAuthTokenTest {
    @Test
    public void testGetSetIdentity() {
        OAuthToken token = new OAuthToken();
        UserIdentity identity = new UserIdentity();
        Assert.assertNull((Object)token.getIdentity());
        token.setIdentity(identity);
        Assert.assertEquals((Object)identity, (Object)token.getIdentity());
    }

    @Test
    public void testGetSetHttpSession() {
        OAuthToken token = new OAuthToken();
        HttpSession session = new HttpSession();
        Assert.assertNull((Object)token.getHttpSession());
        token.setHttpSession(session);
        Assert.assertEquals((Object)session, (Object)token.getHttpSession());
    }

    @Test
    public void testGetSetClient() {
        OAuthToken token = new OAuthToken();
        Client client = new Client();
        Assert.assertNull((Object)token.getClient());
        token.setClient(client);
        Assert.assertEquals((Object)client, (Object)token.getClient());
    }

    @Test
    public void testGetSetTokenType() {
        OAuthToken c = new OAuthToken();
        Assert.assertNull((Object)c.getTokenType());
        c.setTokenType(OAuthTokenType.Authorization);
        Assert.assertEquals((Object)OAuthTokenType.Authorization, (Object)c.getTokenType());
    }

    @Test
    public void testGetSetExpiration() {
        OAuthToken c = new OAuthToken();
        Assert.assertNull((Object)c.getExpiresIn());
        c.setExpiresIn(100);
        Assert.assertEquals((long)100L, (long)c.getExpiresIn());
        c.setExpiresIn(200L);
        Assert.assertEquals((long)200L, (long)c.getExpiresIn());
        c.setExpiresIn((Number)2.222);
        Assert.assertEquals((long)2L, (long)c.getExpiresIn());
        c.setExpiresIn((Number)22);
        Assert.assertEquals((long)22L, (long)c.getExpiresIn());
        c.setExpiresIn((Number)100L);
        Assert.assertEquals((long)100L, (long)c.getExpiresIn());
        c.setExpiresIn((Number)null);
        Assert.assertNull((Object)c.getExpiresIn());
    }

    @Test
    public void testGetSetToken() {
        OAuthToken token = new OAuthToken();
        OAuthToken otherToken = new OAuthToken();
        Assert.assertNull((Object)token.getAuthToken());
        token.setAuthToken(otherToken);
        Assert.assertEquals((Object)otherToken, (Object)token.getAuthToken());
    }

    @Test
    public void testGetSetRedirect() throws Exception {
        OAuthToken token = new OAuthToken();
        URI test = new URI("http://example.com/");
        Assert.assertNull((Object)token.getRedirect());
        token.setRedirect(test);
        Assert.assertEquals((Object)test, (Object)token.getRedirect());
    }

    @Test
    public void testGetSetIssuer() throws Exception {
        OAuthToken token = new OAuthToken();
        Assert.assertNull((Object)token.getIssuer());
        token.setIssuer("test");
        Assert.assertEquals((Object)"test", (Object)token.getIssuer());
    }

    @Test
    public void testGetNameUserIdentity() throws Exception {
        OAuthToken token = new OAuthToken();
        UserIdentity u = new UserIdentity();
        u.setRemoteId("RemoteId");
        Client c = new Client();
        c.setType(ClientType.Implicit);
        c.setName("foo");
        token.setClient(c);
        token.setIdentity(u);
        Assert.assertEquals((Object)u.getRemoteId(), (Object)token.getName());
    }

    @Test
    public void testGetNameClient() throws Exception {
        OAuthToken token = new OAuthToken();
        Client c = new Client();
        c.setType(ClientType.ClientCredentials);
        c.setName("foo");
        token.setClient(c);
        Assert.assertEquals((Object)c.getName(), (Object)token.getName());
    }

    @Test
    public void testGetNullClient() throws Exception {
        OAuthToken token = new OAuthToken();
        Assert.assertNull((Object)token.getName());
    }

    @Test
    public void testGetSetScopes() {
        OAuthToken token = new OAuthToken();
        TreeMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();
        scopes.put("test", new ApplicationScope());
        Assert.assertEquals((long)0L, (long)token.getScopes().size());
        token.setScopes(scopes);
        Assert.assertEquals(scopes, (Object)token.getScopes());
        Assert.assertNotSame(scopes, (Object)token.getScopes());
    }

    @Test
    public void testIsExpired() {
        OAuthToken token = new OAuthToken();
        TimeZone utc = TimeZone.getTimeZone("UTC");
        TimeZone pdt = TimeZone.getTimeZone("PDT");
        Calendar recentUTC = Calendar.getInstance(utc);
        recentUTC.add(13, -100);
        Calendar recentPDT = Calendar.getInstance(pdt);
        recentPDT.add(13, -100);
        Assert.assertTrue((boolean)token.isExpired());
        token.setCreatedDate(recentUTC);
        token.setExpiresIn(103L);
        Assert.assertFalse((boolean)token.isExpired());
        token.setExpiresIn(99L);
        Assert.assertTrue((boolean)token.isExpired());
        token.setCreatedDate(recentPDT);
        token.setExpiresIn(103L);
        Assert.assertFalse((boolean)token.isExpired());
        token.setExpiresIn(99L);
        Assert.assertTrue((boolean)token.isExpired());
    }

    @Test
    public void testGetOwner() {
        OAuthToken token = new OAuthToken();
        Client spy = (Client)Mockito.spy((Object)new Client());
        Assert.assertNull((Object)token.getOwner());
        token.setClient(spy);
        token.getOwner();
        ((Client)Mockito.verify((Object)spy)).getOwner();
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        UserIdentity identity = new UserIdentity();
        identity.setId(IdUtil.next());
        Client client = new Client();
        client.setType(ClientType.ClientCredentials);
        client.setId(IdUtil.next());
        OAuthToken token = new OAuthToken();
        token.setId(IdUtil.next());
        token.setCreatedDate(Calendar.getInstance());
        token.setModifiedDate(Calendar.getInstance());
        token.setIdentity(identity);
        token.setClient(client);
        token.setRedirect(new URI("http://example.com/"));
        token.setTokenType(OAuthTokenType.Authorization);
        token.setExpiresIn(100);
        token.setIssuer("localhost");
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)token);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)token.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(token.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(token.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)token.getTokenType().toString(), (Object)node.get("tokenType").asText());
        Assert.assertEquals((long)token.getExpiresIn(), (long)node.get("expiresIn").asLong());
        Assert.assertEquals((Object)token.getRedirect().toString(), (Object)node.get("redirect").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)token.getClient().getId()), (Object)node.get("client").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)token.getIdentity().getId()), (Object)node.get("identity").asText());
        Assert.assertEquals((Object)token.getIssuer(), (Object)node.get("issuer").asText());
        ArrayList names = new ArrayList();
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        Assert.assertEquals((long)9L, (long)names.size());
    }

    @Test
    public void testJacksonDeserializable() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        long timestamp = Calendar.getInstance().getTimeInMillis() / 1000L;
        ObjectNode node = m.createObjectNode();
        node.put("id", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("createdDate", timestamp);
        node.put("modifiedDate", timestamp);
        node.put("accessToken", "accessToken");
        node.put("tokenType", "Authorization");
        node.put("expiresIn", 300);
        node.put("redirect", "http://example.com");
        node.put("issuer", "localhost");
        node.put("identity", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("client", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("authToken", IdUtil.toString((BigInteger)IdUtil.next()));
        String output = m.writeValueAsString((Object)node);
        OAuthToken c = (OAuthToken)m.readValue(output, OAuthToken.class);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)c.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(c.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(c.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)c.getTokenType().toString(), (Object)node.get("tokenType").asText());
        Assert.assertEquals((long)c.getExpiresIn(), (long)node.get("expiresIn").asLong());
        Assert.assertEquals((Object)c.getIssuer(), (Object)node.get("issuer").asText());
        Assert.assertEquals((Object)c.getRedirect().toString(), (Object)node.get("redirect").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)c.getIdentity().getId()), (Object)node.get("identity").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)c.getClient().getId()), (Object)node.get("client").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)c.getAuthToken().getId()), (Object)node.get("authToken").asText());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger newId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)newId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        OAuthToken.Deserializer deserializer = new OAuthToken.Deserializer();
        OAuthToken c = (OAuthToken)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)newId, (Object)c.getId());
    }
}

