/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import java.util.ArrayList;
import net.krotscheck.kangaroo.authz.common.database.entity.HttpSession;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Test;

public final class HttpSessionTest
extends DatabaseTest {
    @Test
    public void testSimplePersistence() {
        HttpSession httpSession = new HttpSession();
        Assert.assertEquals((long)-1L, (long)httpSession.getSessionTimeout());
        httpSession.setSessionTimeout(1000L);
        Assert.assertNull((Object)httpSession.getId());
        Session s = this.getSession();
        s.beginTransaction();
        s.save((Object)httpSession);
        s.getTransaction().commit();
        Assert.assertNotNull((Object)httpSession.getId());
        Assert.assertEquals((Object)httpSession.getModifiedDate(), (Object)httpSession.getCreatedDate());
        Assert.assertEquals((long)1000L, (long)httpSession.getSessionTimeout());
    }

    @Test
    public void assertGetSetRefreshTokens() {
        HttpSession httpSession = new HttpSession();
        ArrayList<OAuthToken> refreshTokens = new ArrayList<OAuthToken>();
        refreshTokens.add(new OAuthToken());
        Assert.assertEquals((long)0L, (long)httpSession.getRefreshTokens().size());
        httpSession.setRefreshTokens(refreshTokens);
        Assert.assertEquals(refreshTokens, (Object)httpSession.getRefreshTokens());
        Assert.assertNotSame(refreshTokens, (Object)httpSession.getRefreshTokens());
    }
}

