/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;

public final class ClientTypeTest {
    @Test
    public void testSerialization() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        String auth = m.writeValueAsString((Object)ClientType.AuthorizationGrant);
        Assert.assertEquals((Object)"\"AuthorizationGrant\"", (Object)auth);
        String implicit = m.writeValueAsString((Object)ClientType.Implicit);
        Assert.assertEquals((Object)"\"Implicit\"", (Object)implicit);
        String owner = m.writeValueAsString((Object)ClientType.OwnerCredentials);
        Assert.assertEquals((Object)"\"OwnerCredentials\"", (Object)owner);
        String client = m.writeValueAsString((Object)ClientType.ClientCredentials);
        Assert.assertEquals((Object)"\"ClientCredentials\"", (Object)client);
    }

    @Test
    public void testDeserialization() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        ClientType auth = (ClientType)m.readValue("\"AuthorizationGrant\"", ClientType.class);
        Assert.assertSame((Object)auth, (Object)ClientType.AuthorizationGrant);
        ClientType implicit = (ClientType)m.readValue("\"Implicit\"", ClientType.class);
        Assert.assertSame((Object)implicit, (Object)ClientType.Implicit);
        ClientType owner = (ClientType)m.readValue("\"OwnerCredentials\"", ClientType.class);
        Assert.assertSame((Object)owner, (Object)ClientType.OwnerCredentials);
        ClientType client = (ClientType)m.readValue("\"ClientCredentials\"", ClientType.class);
        Assert.assertSame((Object)client, (Object)ClientType.ClientCredentials);
    }

    @Test
    public void testInWithValues() {
        Assert.assertFalse((boolean)ClientType.AuthorizationGrant.in(new ClientType[0]));
        Assert.assertFalse((boolean)ClientType.AuthorizationGrant.in(null));
        Assert.assertTrue((boolean)ClientType.AuthorizationGrant.in(new ClientType[]{ClientType.ClientCredentials, ClientType.AuthorizationGrant}));
        Assert.assertTrue((boolean)ClientType.AuthorizationGrant.in(new ClientType[]{ClientType.AuthorizationGrant}));
        Assert.assertTrue((boolean)ClientType.AuthorizationGrant.in(new ClientType[]{ClientType.AuthorizationGrant, ClientType.AuthorizationGrant, ClientType.AuthorizationGrant}));
        Assert.assertFalse((boolean)ClientType.AuthorizationGrant.in(new ClientType[]{ClientType.Implicit, ClientType.ClientCredentials, ClientType.OwnerCredentials}));
    }

    @Test
    public void testValueOf() {
        Assert.assertEquals((Object)ClientType.AuthorizationGrant, (Object)ClientType.valueOf((String)"AuthorizationGrant"));
        Assert.assertEquals((Object)ClientType.Implicit, (Object)ClientType.valueOf((String)"Implicit"));
        Assert.assertEquals((Object)ClientType.ClientCredentials, (Object)ClientType.valueOf((String)"ClientCredentials"));
        Assert.assertEquals((Object)ClientType.OwnerCredentials, (Object)ClientType.valueOf((String)"OwnerCredentials"));
    }
}

