/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientReferrer;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class ClientTest {
    @Test
    public void testGetSetApplication() {
        Client c = new Client();
        Application a = new Application();
        Assert.assertNull((Object)c.getApplication());
        c.setApplication(a);
        Assert.assertEquals((Object)a, (Object)c.getApplication());
    }

    @Test
    public void testGetSetName() {
        Client c = new Client();
        String name = "test";
        Assert.assertNull((Object)c.getName());
        c.setName(name);
        Assert.assertEquals((Object)name, (Object)c.getName());
    }

    @Test
    public void testGetSetSecret() {
        Client c = new Client();
        String secret = "secret";
        Assert.assertNull((Object)c.getClientSecret());
        c.setClientSecret(secret);
        Assert.assertEquals((Object)secret, (Object)c.getClientSecret());
    }

    @Test
    public void testGetSetType() {
        Client c = new Client();
        Assert.assertNull((Object)c.getType());
        c.setType(ClientType.Implicit);
        Assert.assertEquals((Object)ClientType.Implicit, (Object)c.getType());
    }

    @Test
    public void testGetSetReferrers() throws Exception {
        Client c = new Client();
        ArrayList<ClientReferrer> referrers = new ArrayList<ClientReferrer>();
        URI referrer = new URI("https://example.com/oauth/foo?lol=cat#omg");
        ClientReferrer r = new ClientReferrer();
        r.setClient(c);
        r.setUri(referrer);
        referrers.add(r);
        Assert.assertEquals((long)0L, (long)c.getReferrers().size());
        c.setReferrers(referrers);
        Assert.assertEquals(referrers, (Object)c.getReferrers());
        Assert.assertTrue((boolean)c.getReferrers().contains(r));
    }

    @Test
    public void testGetSetRedirects() throws Exception {
        Client c = new Client();
        ArrayList<ClientRedirect> redirects = new ArrayList<ClientRedirect>();
        URI referrer = new URI("https://example.com/oauth/foo?lol=cat#omg");
        ClientRedirect r = new ClientRedirect();
        r.setClient(c);
        r.setUri(referrer);
        redirects.add(r);
        Assert.assertEquals((long)0L, (long)c.getRedirects().size());
        c.setRedirects(redirects);
        Assert.assertEquals(redirects, (Object)c.getRedirects());
        Assert.assertTrue((boolean)c.getRedirects().contains(r));
    }

    @Test
    public void testGetSetTokens() {
        Client client = new Client();
        ArrayList<OAuthToken> tokens = new ArrayList<OAuthToken>();
        tokens.add(new OAuthToken());
        Assert.assertEquals((long)0L, (long)client.getTokens().size());
        client.setTokens(tokens);
        Assert.assertEquals(tokens, (Object)client.getTokens());
        Assert.assertNotSame(tokens, (Object)client.getTokens());
    }

    @Test
    public void testGetSetAuthenticators() {
        Client client = new Client();
        ArrayList<Authenticator> authenticators = new ArrayList<Authenticator>();
        authenticators.add(new Authenticator());
        Assert.assertEquals((long)0L, (long)client.getAuthenticators().size());
        client.setAuthenticators(authenticators);
        Assert.assertEquals(authenticators, (Object)client.getAuthenticators());
        Assert.assertNotSame(authenticators, (Object)client.getAuthenticators());
    }

    @Test
    public void testGetSetConfiguration() {
        Client client = new Client();
        HashMap configuration = new HashMap();
        Assert.assertEquals((long)0L, (long)client.getConfiguration().size());
        client.setConfiguration(configuration);
        Assert.assertEquals(configuration, (Object)client.getConfiguration());
        Assert.assertNotSame(configuration, (Object)client.getConfiguration());
    }

    @Test
    public void testGetAccessExpiresIn() {
        Client client = new Client();
        HashMap<String, String> configuration = new HashMap<String, String>();
        Integer expectedDefault = 600;
        Assert.assertEquals((Object)expectedDefault, (Object)client.getAccessTokenExpireIn());
        client.setConfiguration(configuration);
        Assert.assertEquals((Object)expectedDefault, (Object)client.getAccessTokenExpireIn());
        configuration.put("access_token_expires_in", "not_an_int");
        client.setConfiguration(configuration);
        Assert.assertEquals((Object)expectedDefault, (Object)client.getAccessTokenExpireIn());
        configuration.put("access_token_expires_in", "50");
        client.setConfiguration(configuration);
        Assert.assertEquals((Object)50, (Object)client.getAccessTokenExpireIn());
    }

    @Test
    public void testGetRefreshExpiresIn() {
        Client client = new Client();
        HashMap<String, String> configuration = new HashMap<String, String>();
        Integer expectedDefault = 2592000;
        Assert.assertEquals((Object)expectedDefault, (Object)client.getRefreshTokenExpireIn());
        client.setConfiguration(configuration);
        Assert.assertEquals((Object)expectedDefault, (Object)client.getRefreshTokenExpireIn());
        configuration.put("refresh_token_expires_in", "not_an_int");
        client.setConfiguration(configuration);
        Assert.assertEquals((Object)expectedDefault, (Object)client.getRefreshTokenExpireIn());
        configuration.put("refresh_token_expires_in", "50");
        client.setConfiguration(configuration);
        Assert.assertEquals((Object)50, (Object)client.getRefreshTokenExpireIn());
    }

    @Test
    public void getGetAuthorizationCodeExpiresIn() {
        Client client = new Client();
        HashMap<String, String> configuration = new HashMap<String, String>();
        Integer expectedDefault = 600;
        Assert.assertEquals((Object)expectedDefault, (Object)client.getAuthorizationCodeExpiresIn());
        client.setConfiguration(configuration);
        Assert.assertEquals((Object)expectedDefault, (Object)client.getAuthorizationCodeExpiresIn());
        configuration.put("authorization_code_expires_in", "not_an_int");
        client.setConfiguration(configuration);
        Assert.assertEquals((Object)expectedDefault, (Object)client.getAuthorizationCodeExpiresIn());
        configuration.put("authorization_code_expires_in", "50");
        client.setConfiguration(configuration);
        Assert.assertEquals((Object)50, (Object)client.getAuthorizationCodeExpiresIn());
    }

    @Test
    public void testGetOwner() {
        Client client = new Client();
        Application spy = (Application)Mockito.spy((Object)new Application());
        Assert.assertNull((Object)client.getOwner());
        client.setApplication(spy);
        client.getOwner();
        ((Application)Mockito.verify((Object)spy)).getOwner();
    }

    @Test
    public void testIsPrivate() {
        Client c = new Client();
        Assert.assertFalse((boolean)c.isPrivate());
        c.setClientSecret("new secret");
        Assert.assertTrue((boolean)c.isPrivate());
    }

    @Test
    public void testIsPublic() {
        Client c = new Client();
        Assert.assertTrue((boolean)c.isPublic());
        c.setClientSecret("new secret");
        Assert.assertFalse((boolean)c.isPublic());
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        Application application = new Application();
        application.setId(IdUtil.next());
        ArrayList<OAuthToken> tokens = new ArrayList<OAuthToken>();
        OAuthToken token = new OAuthToken();
        token.setId(IdUtil.next());
        tokens.add(token);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("one", "value");
        configuration.put("two", "value");
        Client c = new Client();
        c.setApplication(application);
        c.setId(IdUtil.next());
        c.setCreatedDate(Calendar.getInstance());
        c.setModifiedDate(Calendar.getInstance());
        c.setName("name");
        c.setClientSecret("clientSecret");
        c.setType(ClientType.AuthorizationGrant);
        c.setConfiguration(configuration);
        ArrayList redirects = new ArrayList();
        ClientRedirect redirect = new ClientRedirect();
        redirect.setClient(c);
        redirect.setUri(new URI("https://example.com/oauth/foo?lol=cat#omg"));
        c.getRedirects().add(redirect);
        ArrayList referrers = new ArrayList();
        ClientReferrer referrer = new ClientReferrer();
        redirect.setClient(c);
        redirect.setUri(new URI("https://example.com/oauth/foo?lol=cat#omg"));
        c.getReferrers().add(referrer);
        c.setTokens(tokens);
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)c);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)c.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(c.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(c.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)c.getApplication().getId()), (Object)node.get("application").asText());
        Assert.assertEquals((Object)c.getName(), (Object)node.get("name").asText());
        Assert.assertEquals((Object)c.getClientSecret(), (Object)node.get("clientSecret").asText());
        Assert.assertEquals((Object)c.getType().toString(), (Object)node.get("type").asText());
        Assert.assertFalse((boolean)node.has("tokens"));
        JsonNode configurationNode = node.get("configuration");
        Assert.assertEquals((Object)"value", (Object)configurationNode.get("one").asText());
        Assert.assertEquals((Object)"value", (Object)configurationNode.get("two").asText());
        Assert.assertFalse((boolean)node.has("referrers"));
        Assert.assertFalse((boolean)node.has("redirects"));
        Assert.assertFalse((boolean)node.has("tokens"));
        ArrayList names = new ArrayList();
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        Assert.assertEquals((long)8L, (long)names.size());
    }

    @Test
    public void testJacksonDeserializable() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        long timestamp = Calendar.getInstance().getTimeInMillis() / 1000L;
        ObjectNode node = m.createObjectNode();
        node.put("id", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("createdDate", timestamp);
        node.put("modifiedDate", timestamp);
        node.put("name", "name");
        node.put("type", "Implicit");
        node.put("clientSecret", "clientSecret");
        node.put("application", IdUtil.toString((BigInteger)IdUtil.next()));
        ObjectNode configurationNode = m.createObjectNode();
        configurationNode.put("one", "value");
        configurationNode.put("two", "value");
        node.set("configuration", (JsonNode)configurationNode);
        String output = m.writeValueAsString((Object)node);
        Client c = (Client)m.readValue(output, Client.class);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)c.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(c.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(c.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)c.getName(), (Object)node.get("name").asText());
        Assert.assertEquals((Object)c.getClientSecret(), (Object)node.get("clientSecret").asText());
        Assert.assertEquals((Object)c.getType().toString(), (Object)node.get("type").asText());
        Map configuration = c.getConfiguration();
        Assert.assertEquals(configuration.get("one"), (Object)configurationNode.get("one").asText());
        Assert.assertEquals(configuration.get("two"), (Object)configurationNode.get("two").asText());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger newId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)newId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        Client.Deserializer deserializer = new Client.Deserializer();
        Client c = (Client)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)newId, (Object)c.getId());
    }
}

