/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class ClientRedirectTest {
    @Test
    public void testGetSetClient() {
        ClientRedirect redirect = new ClientRedirect();
        Client client = new Client();
        Assert.assertNull((Object)redirect.getClient());
        redirect.setClient(client);
        Assert.assertEquals((Object)client, (Object)redirect.getClient());
    }

    @Test
    public void testGetSetUri() {
        ClientRedirect redirect = new ClientRedirect();
        URI uri = URI.create("http://example.com/");
        Assert.assertNull((Object)redirect.getUri());
        redirect.setUri(uri);
        Assert.assertEquals((Object)uri, (Object)redirect.getUri());
    }

    @Test
    public void testGetOwner() {
        ClientRedirect redirect = new ClientRedirect();
        Client spy = (Client)Mockito.spy((Object)new Client());
        Assert.assertNull((Object)redirect.getOwner());
        redirect.setClient(spy);
        redirect.getOwner();
        ((Client)Mockito.verify((Object)spy)).getOwner();
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        Client client = new Client();
        client.setId(IdUtil.next());
        ClientRedirect r = new ClientRedirect();
        r.setClient(client);
        r.setUri(URI.create("http://example.com/"));
        r.setId(IdUtil.next());
        r.setCreatedDate(Calendar.getInstance());
        r.setModifiedDate(Calendar.getInstance());
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)r);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)r.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(r.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(r.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)r.getUri().toString(), (Object)node.get("uri").asText());
        ArrayList names = new ArrayList();
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        Assert.assertEquals((long)4L, (long)names.size());
    }

    @Test
    public void testJacksonDeserializable() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        long timestamp = Calendar.getInstance().getTimeInMillis() / 1000L;
        ObjectNode node = m.createObjectNode();
        node.put("id", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("createdDate", timestamp);
        node.put("modifiedDate", timestamp);
        node.put("client", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("uri", "http://example.com/");
        String output = m.writeValueAsString((Object)node);
        ClientRedirect r = (ClientRedirect)m.readValue(output, ClientRedirect.class);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)r.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(r.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(r.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)r.getUri().toString(), (Object)node.get("uri").asText());
        Assert.assertNull((Object)r.getClient());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger newId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)newId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        Client.Deserializer deserializer = new Client.Deserializer();
        Client c = (Client)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)newId, (Object)c.getId());
    }
}

