/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.AuthenticatorState;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class AuthenticatorTest {
    @Test
    public void testGetSetClient() {
        Authenticator auth = new Authenticator();
        Client client = new Client();
        Assert.assertNull((Object)auth.getClient());
        auth.setClient(client);
        Assert.assertEquals((Object)client, (Object)auth.getClient());
    }

    @Test
    public void testGetSetType() {
        Authenticator auth = new Authenticator();
        Assert.assertNull((Object)auth.getType());
        auth.setType(AuthenticatorType.Password);
        Assert.assertEquals((Object)AuthenticatorType.Password, (Object)auth.getType());
    }

    @Test
    public void testGetSetConfiguration() {
        Authenticator auth = new Authenticator();
        HashMap config = new HashMap();
        Assert.assertEquals((long)0L, (long)auth.getConfiguration().size());
        auth.setConfiguration(config);
        Assert.assertEquals(config, (Object)auth.getConfiguration());
    }

    @Test
    public void testGetSetStates() {
        Authenticator a = new Authenticator();
        ArrayList<AuthenticatorState> states = new ArrayList<AuthenticatorState>();
        states.add(new AuthenticatorState());
        Assert.assertEquals((long)0L, (long)a.getStates().size());
        a.setStates(states);
        Assert.assertEquals(states, (Object)a.getStates());
        Assert.assertNotSame(states, (Object)a.getStates());
    }

    @Test
    public void testGetOwner() {
        Authenticator authenticator = new Authenticator();
        Client spy = (Client)Mockito.spy((Object)new Client());
        Assert.assertNull((Object)authenticator.getOwner());
        authenticator.setClient(spy);
        authenticator.getOwner();
        ((Client)Mockito.verify((Object)spy)).getOwner();
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        Client client = new Client();
        client.setId(IdUtil.next());
        ArrayList<UserIdentity> identities = new ArrayList<UserIdentity>();
        UserIdentity identity = new UserIdentity();
        identity.setId(IdUtil.next());
        identities.add(identity);
        ArrayList<AuthenticatorState> states = new ArrayList<AuthenticatorState>();
        AuthenticatorState state = new AuthenticatorState();
        state.setId(IdUtil.next());
        states.add(state);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("one", "value");
        config.put("two", "value");
        Authenticator a = new Authenticator();
        a.setId(IdUtil.next());
        a.setClient(client);
        a.setCreatedDate(Calendar.getInstance());
        a.setModifiedDate(Calendar.getInstance());
        a.setType(AuthenticatorType.Test);
        a.setConfiguration(config);
        a.setStates(states);
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)a);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(a.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(a.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getClient().getId()), (Object)node.get("client").asText());
        Assert.assertEquals((Object)a.getType().toString(), (Object)node.get("type").asText());
        JsonNode configNode = node.get("configuration");
        Assert.assertEquals((Object)"value", (Object)configNode.get("one").asText());
        Assert.assertEquals((Object)"value", (Object)configNode.get("two").asText());
        Assert.assertFalse((boolean)node.has("identities"));
        Assert.assertFalse((boolean)node.has("states"));
        ArrayList names = new ArrayList();
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        Assert.assertEquals((long)6L, (long)names.size());
    }

    @Test
    public void testJacksonDeserializable() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        long timestamp = Calendar.getInstance().getTimeInMillis() / 1000L;
        ObjectNode node = m.createObjectNode();
        node.put("id", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("createdDate", timestamp);
        node.put("modifiedDate", timestamp);
        node.put("type", AuthenticatorType.Test.toString());
        ObjectNode configNode = m.createObjectNode();
        configNode.put("one", "value");
        configNode.put("two", "value");
        node.set("configuration", (JsonNode)configNode);
        String output = m.writeValueAsString((Object)node);
        Authenticator a = (Authenticator)m.readValue(output, Authenticator.class);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(a.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(a.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)a.getType().toString(), (Object)node.get("type").asText());
        Assert.assertNull((Object)a.getClient());
        Map config = a.getConfiguration();
        Assert.assertEquals(config.get("one"), (Object)configNode.get("one").asText());
        Assert.assertEquals(config.get("two"), (Object)configNode.get("two").asText());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger newId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)newId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        Authenticator.Deserializer deserializer = new Authenticator.Deserializer();
        Authenticator u = (Authenticator)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)newId, (Object)u.getId());
    }
}

