/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import java.net.URI;
import java.util.TreeMap;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.AuthenticatorState;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class AuthenticatorStateTest {
    @Test
    public void testGetSetAuthenticator() {
        AuthenticatorState token = new AuthenticatorState();
        Authenticator authenticator = new Authenticator();
        Assert.assertNull((Object)token.getAuthenticator());
        token.setAuthenticator(authenticator);
        Assert.assertEquals((Object)authenticator, (Object)token.getAuthenticator());
    }

    @Test
    public void testGetSetClientState() {
        AuthenticatorState state = new AuthenticatorState();
        Assert.assertNull((Object)state.getClientState());
        state.setClientState("state");
        Assert.assertEquals((Object)"state", (Object)state.getClientState());
    }

    @Test
    public void testGetSetClientRedirect() {
        AuthenticatorState state = new AuthenticatorState();
        URI testUri = UriBuilder.fromUri((String)"http://valid.example.com/").build(new Object[0]);
        Assert.assertNull((Object)state.getClientRedirect());
        state.setClientRedirect(testUri);
        Assert.assertEquals((Object)testUri, (Object)state.getClientRedirect());
    }

    @Test
    public void testGetSetScopes() {
        AuthenticatorState state = new AuthenticatorState();
        TreeMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();
        scopes.put("test", new ApplicationScope());
        Assert.assertEquals((long)0L, (long)state.getClientScopes().size());
        state.setClientScopes(scopes);
        Assert.assertEquals(scopes, (Object)state.getClientScopes());
        Assert.assertNotSame(scopes, (Object)state.getClientScopes());
    }

    @Test
    public void testGetOwner() {
        AuthenticatorState state = new AuthenticatorState();
        Authenticator spy = (Authenticator)Mockito.spy((Object)new Authenticator());
        Assert.assertNull((Object)state.getOwner());
        state.setAuthenticator(spy);
        state.getOwner();
        ((Authenticator)Mockito.verify((Object)spy)).getOwner();
    }
}

