/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TreeMap;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class ApplicationTest {
    @Test
    public void testGetSetOwner() {
        Application application = new Application();
        User user = new User();
        Assert.assertNull((Object)application.getOwner());
        application.setOwner(user);
        Assert.assertEquals((Object)user, (Object)application.getOwner());
    }

    @Test
    public void testGetSetDefaultRole() {
        Application application = new Application();
        Role role = new Role();
        Assert.assertNull((Object)application.getDefaultRole());
        application.setDefaultRole(role);
        Assert.assertEquals((Object)role, (Object)application.getDefaultRole());
    }

    @Test
    public void testGetSetName() {
        Application a = new Application();
        Assert.assertNull((Object)a.getName());
        a.setName("foo");
        Assert.assertEquals((Object)"foo", (Object)a.getName());
    }

    @Test
    public void testGetSetDescription() {
        Application a = new Application();
        Assert.assertNull((Object)a.getDescription());
        a.setDescription("The application description");
        Assert.assertEquals((Object)"The application description", (Object)a.getDescription());
    }

    @Test
    public void testGetSetUsers() {
        Application a = new Application();
        ArrayList<User> users = new ArrayList<User>();
        users.add(new User());
        Assert.assertEquals((long)0L, (long)a.getUsers().size());
        a.setUsers(users);
        Assert.assertEquals(users, (Object)a.getUsers());
        Assert.assertNotSame(users, (Object)a.getUsers());
    }

    @Test
    public void testGetSetClients() {
        Application a = new Application();
        ArrayList<Client> clients = new ArrayList<Client>();
        clients.add(new Client());
        Assert.assertEquals((long)0L, (long)a.getClients().size());
        a.setClients(clients);
        Assert.assertEquals(clients, (Object)a.getClients());
        Assert.assertNotSame(clients, (Object)a.getClients());
    }

    @Test
    public void testGetSetRoles() {
        Application a = new Application();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(new Role());
        Assert.assertEquals((long)0L, (long)a.getRoles().size());
        a.setRoles(roles);
        Assert.assertEquals(roles, (Object)a.getRoles());
        Assert.assertNotSame(roles, (Object)a.getRoles());
    }

    @Test
    public void testGetSetScopes() {
        Application a = new Application();
        TreeMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();
        scopes.put("foo", new ApplicationScope());
        Assert.assertEquals((long)0L, (long)a.getScopes().size());
        a.setScopes(scopes);
        Assert.assertEquals(scopes, (Object)a.getScopes());
        Assert.assertNotSame(scopes, (Object)a.getScopes());
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        User owner = new User();
        owner.setId(IdUtil.next());
        Role defaultRole = new Role();
        defaultRole.setId(IdUtil.next());
        ArrayList<User> users = new ArrayList<User>();
        User user = new User();
        user.setId(IdUtil.next());
        users.add(user);
        ArrayList<Client> clients = new ArrayList<Client>();
        Client client = new Client();
        client.setId(IdUtil.next());
        clients.add(client);
        ArrayList<Role> roles = new ArrayList<Role>();
        Role role = new Role();
        role.setId(IdUtil.next());
        roles.add(role);
        Application a = new Application();
        a.setId(IdUtil.next());
        a.setCreatedDate(Calendar.getInstance());
        a.setModifiedDate(Calendar.getInstance());
        a.setOwner(owner);
        a.setName("name");
        a.setDescription("description");
        a.setDefaultRole(defaultRole);
        a.setClients(clients);
        a.setRoles(roles);
        a.setUsers(users);
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)a);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(a.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(a.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getOwner().getId()), (Object)node.get("owner").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getDefaultRole().getId()), (Object)node.get("defaultRole").asText());
        Assert.assertEquals((Object)a.getName(), (Object)node.get("name").asText());
        Assert.assertEquals((Object)a.getDescription(), (Object)node.get("description").asText());
        Assert.assertFalse((boolean)node.has("clients"));
        Assert.assertFalse((boolean)node.has("roles"));
        Assert.assertFalse((boolean)node.has("users"));
        ArrayList names = new ArrayList();
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        Assert.assertEquals((long)7L, (long)names.size());
    }

    @Test
    public void testJacksonDeserializable() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        long timestamp = Calendar.getInstance().getTimeInMillis() / 1000L;
        ObjectNode node = m.createObjectNode();
        node.put("id", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("createdDate", timestamp);
        node.put("modifiedDate", timestamp);
        node.put("name", "name");
        node.put("description", "description");
        node.put("owner", IdUtil.toString((BigInteger)IdUtil.next()));
        String output = m.writeValueAsString((Object)node);
        Application a = (Application)m.readValue(output, Application.class);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(a.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(a.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)a.getName(), (Object)node.get("name").asText());
        Assert.assertEquals((Object)a.getDescription(), (Object)node.get("description").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getOwner().getId()), (Object)node.get("owner").asText());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger newInteger = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)newInteger));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        Application.Deserializer deserializer = new Application.Deserializer();
        Application a = (Application)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)newInteger, (Object)a.getId());
    }
}

