/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class ApplicationScopeTest {
    @Test
    public void testGetSetApplication() {
        ApplicationScope scope = new ApplicationScope();
        Application application = new Application();
        Assert.assertNull((Object)scope.getApplication());
        scope.setApplication(application);
        Assert.assertEquals((Object)application, (Object)scope.getApplication());
    }

    @Test
    public void testGetSetName() {
        ApplicationScope a = new ApplicationScope();
        Assert.assertNull((Object)a.getName());
        a.setName("foo");
        Assert.assertEquals((Object)"foo", (Object)a.getName());
    }

    @Test
    public void testGetSetRoles() {
        ApplicationScope scope = new ApplicationScope();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(new Role());
        Assert.assertTrue((scope.getRoles().size() == 0 ? 1 : 0) != 0);
        scope.setRoles(roles);
        Assert.assertEquals(roles, (Object)scope.getRoles());
        Assert.assertNotSame(roles, (Object)scope.getRoles());
    }

    @Test
    public void testGetSetTokens() {
        ApplicationScope scope = new ApplicationScope();
        ArrayList<OAuthToken> tokens = new ArrayList<OAuthToken>();
        tokens.add(new OAuthToken());
        Assert.assertTrue((scope.getTokens().size() == 0 ? 1 : 0) != 0);
        scope.setTokens(tokens);
        Assert.assertEquals(tokens, (Object)scope.getTokens());
        Assert.assertNotSame(tokens, (Object)scope.getTokens());
    }

    @Test
    public void testGetOwner() {
        ApplicationScope scope = new ApplicationScope();
        Application spy = (Application)Mockito.spy((Object)new Application());
        Assert.assertNull((Object)scope.getOwner());
        scope.setApplication(spy);
        scope.getOwner();
        ((Application)Mockito.verify((Object)spy)).getOwner();
    }

    @Test
    public void testJacksonSerializable() throws Exception {
        Application application = new Application();
        application.setId(IdUtil.next());
        ApplicationScope a = new ApplicationScope();
        a.setId(IdUtil.next());
        a.setCreatedDate(Calendar.getInstance());
        a.setModifiedDate(Calendar.getInstance());
        a.setApplication(application);
        a.setName("name");
        ObjectMapper m = new ObjectMapperFactory().get();
        String output = m.writeValueAsString((Object)a);
        JsonNode node = m.readTree(output);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(a.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(a.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getApplication().getId()), (Object)node.get("application").asText());
        Assert.assertEquals((Object)a.getName(), (Object)node.get("name").asText());
        ArrayList names = new ArrayList();
        Iterator nameIterator = node.fieldNames();
        while (nameIterator.hasNext()) {
            names.add(nameIterator.next());
        }
        Assert.assertEquals((long)5L, (long)names.size());
    }

    @Test
    public void testJacksonDeserializable() throws Exception {
        ObjectMapper m = new ObjectMapperFactory().get();
        long timestamp = Calendar.getInstance().getTimeInMillis() / 1000L;
        ObjectNode node = m.createObjectNode();
        node.put("id", IdUtil.toString((BigInteger)IdUtil.next()));
        node.put("createdDate", timestamp);
        node.put("modifiedDate", timestamp);
        node.put("name", "name");
        node.put("application", IdUtil.toString((BigInteger)IdUtil.next()));
        String output = m.writeValueAsString((Object)node);
        ApplicationScope a = (ApplicationScope)m.readValue(output, ApplicationScope.class);
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getId()), (Object)node.get("id").asText());
        Assert.assertEquals((long)(a.getCreatedDate().getTimeInMillis() / 1000L), (long)node.get("createdDate").asLong());
        Assert.assertEquals((long)(a.getModifiedDate().getTimeInMillis() / 1000L), (long)node.get("modifiedDate").asLong());
        Assert.assertEquals((Object)a.getName(), (Object)node.get("name").asText());
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)a.getApplication().getId()), (Object)node.get("application").asText());
    }

    @Test
    public void testDeserializeSimple() throws Exception {
        BigInteger newId = IdUtil.next();
        String id = String.format("\"%s\"", IdUtil.toString((BigInteger)newId));
        JsonFactory f = new JsonFactory();
        JsonParser preloadedParser = f.createParser(id);
        preloadedParser.nextToken();
        ApplicationScope.Deserializer deserializer = new ApplicationScope.Deserializer();
        ApplicationScope a = (ApplicationScope)deserializer.deserialize(preloadedParser, (DeserializationContext)Mockito.mock(DeserializationContext.class));
        Assert.assertEquals((Object)newId, (Object)a.getId());
    }
}

