/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.database.DatabaseFeature;
import net.krotscheck.kangaroo.common.config.ConfigurationFeature;
import net.krotscheck.kangaroo.common.hibernate.listener.CreatedUpdatedListener;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.ResourceConfig;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.junit.Assert;
import org.junit.Test;

public final class DatabaseFeatureTest
extends ContainerTest {
    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(ConfigurationFeature.class);
        a.register(DatabaseFeature.class);
        a.register(MockService.class);
        return a;
    }

    @Test
    public void testStatus() {
        String response = (String)this.target("/").request().get(String.class);
        Assert.assertEquals((Object)"true", (Object)response);
    }

    @Path(value="/")
    public static final class MockService {
        private InjectionManager injector;

        @Inject
        public MockService(InjectionManager injector) {
            this.injector = injector;
        }

        @GET
        @Produces(value={"application/json"})
        public Response status() {
            List insertListeners = this.injector.getAllInstances(PreInsertEventListener.class);
            List updateListeners = this.injector.getAllInstances(PreUpdateEventListener.class);
            Assert.assertEquals((long)1L, (long)insertListeners.size());
            Assert.assertEquals((long)1L, (long)updateListeners.size());
            Assert.assertTrue((boolean)CreatedUpdatedListener.class.isInstance(insertListeners.get(0)));
            Assert.assertTrue((boolean)CreatedUpdatedListener.class.isInstance(updateListeners.get(0)));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)true).build();
        }
    }
}

