/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.cors;

import java.net.URI;
import java.util.concurrent.ExecutionException;
import net.krotscheck.kangaroo.authz.common.cors.HibernateCORSCacheLoader;
import net.krotscheck.kangaroo.authz.common.cors.HibernateCORSValidator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class HibernateCORSValidatorTest {
    @Test
    public void loadValid() throws Exception {
        HibernateCORSCacheLoader loader = (HibernateCORSCacheLoader)Mockito.mock(HibernateCORSCacheLoader.class);
        ((HibernateCORSCacheLoader)Mockito.doReturn((Object)true).when((Object)loader)).load((URI)Matchers.any(URI.class));
        HibernateCORSValidator validator = new HibernateCORSValidator(loader);
        URI uri = new URI("http://valid.example.com");
        Boolean response1 = validator.isValidCORSOrigin(uri);
        validator.isValidCORSOrigin(uri);
        Assert.assertTrue((boolean)response1);
        ((HibernateCORSCacheLoader)Mockito.verify((Object)loader, (VerificationMode)Mockito.times((int)1))).load((URI)Matchers.any(URI.class));
    }

    @Test
    public void loadValidWithException() throws Exception {
        HibernateCORSCacheLoader loader = (HibernateCORSCacheLoader)Mockito.mock(HibernateCORSCacheLoader.class);
        ((HibernateCORSCacheLoader)Mockito.doThrow(ExecutionException.class).when((Object)loader)).load((URI)Matchers.any(URI.class));
        HibernateCORSValidator validator = new HibernateCORSValidator(loader);
        URI uri = new URI("http://valid.example.com");
        Boolean response1 = validator.isValidCORSOrigin(uri);
        validator.isValidCORSOrigin(uri);
        Assert.assertFalse((boolean)response1);
        ((HibernateCORSCacheLoader)Mockito.verify((Object)loader, (VerificationMode)Mockito.times((int)2))).load((URI)Matchers.any(URI.class));
    }
}

