/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.cors;

import java.net.URI;
import net.krotscheck.kangaroo.authz.admin.v1.test.rule.TestDataResource;
import net.krotscheck.kangaroo.authz.common.cors.HibernateCORSCacheLoader;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public final class HibernateCORSCacheLoaderTest
extends DatabaseTest {
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE);

    @Test
    public void loadValid() throws Exception {
        TEST_DATA_RESOURCE.getAdminApplication().getBuilder().referrer("https://valid.example.com").build();
        URI valid = new URI("https://valid.example.com");
        HibernateCORSCacheLoader loader = new HibernateCORSCacheLoader(this.getSessionFactory());
        Boolean result = loader.load(valid);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void loadInvalid() throws Exception {
        URI invalid = new URI("https://invalid.example.com");
        HibernateCORSCacheLoader loader = new HibernateCORSCacheLoader(this.getSessionFactory());
        Boolean result = loader.load(invalid);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void loadWithHibernateException() throws Exception {
        SessionFactory mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Session mockSession = (Session)Mockito.mock(Session.class);
        ((SessionFactory)Mockito.doReturn((Object)mockSession).when((Object)mockFactory)).openSession();
        ((Session)Mockito.doThrow(HibernateException.class).when((Object)mockSession)).beginTransaction();
        URI invalid = new URI("https://invalid.example.com");
        HibernateCORSCacheLoader loader = new HibernateCORSCacheLoader(mockFactory);
        Boolean result = loader.load(invalid);
        Assert.assertFalse((boolean)result);
    }

    @Test(expected=Exception.class)
    public void loadWithGenericException() throws Exception {
        SessionFactory mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Session mockSession = (Session)Mockito.mock(Session.class);
        ((SessionFactory)Mockito.doReturn((Object)mockSession).when((Object)mockFactory)).openSession();
        ((Session)Mockito.doThrow(Exception.class).when((Object)mockSession)).beginTransaction();
        URI invalid = new URI("https://invalid.example.com");
        HibernateCORSCacheLoader loader = new HibernateCORSCacheLoader(mockFactory);
        Boolean result = loader.load(invalid);
        Assert.assertFalse((boolean)result);
    }
}

