/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.cors;

import java.math.BigInteger;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.AdminV1API;
import net.krotscheck.kangaroo.authz.admin.v1.test.rule.TestDataResource;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public final class AuthzCORSFeatureTest
extends ContainerTest {
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE);

    protected ResourceConfig createApplication() {
        return new AdminV1API();
    }

    @Test
    public void testListResponse() {
        ApplicationBuilder.ApplicationContext context = TEST_DATA_RESOURCE.getAdminApplication();
        context.getBuilder().referrer("http://valid.example.com").build();
        OAuthToken adminAppToken = context.getBuilder().bearerToken("kangaroo:application_admin").build().getToken();
        Response r = this.target("/application/").request().header("Origin", (Object)"http://valid.example.com").header("Authorization", (Object)HttpUtil.authHeaderBearer((BigInteger)adminAppToken.getId())).get();
        MultivaluedMap headers = r.getHeaders();
        List exposedHeaders = (List)headers.get((Object)"Access-Control-Expose-Headers");
        Assert.assertTrue((exposedHeaders.indexOf("Limit".toLowerCase()) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((exposedHeaders.indexOf("Offset".toLowerCase()) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((exposedHeaders.indexOf("Order".toLowerCase()) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((exposedHeaders.indexOf("Sort".toLowerCase()) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((exposedHeaders.indexOf("Total".toLowerCase()) > -1 ? 1 : 0) != 0);
    }
}

