/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.test;

import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.test.TestAuthenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

public final class TestAuthenticatorTest
extends DatabaseTest {
    private static ApplicationBuilder.ApplicationContext context;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    @Test
    public void delegate() {
        Session session = (Session)Mockito.mock(Session.class);
        TestAuthenticator a = new TestAuthenticator(session);
        Authenticator config = new Authenticator();
        URI testUri = UriBuilder.fromUri((String)"http://example.com/redirect").build(new Object[0]);
        Response r = a.delegate(config, testUri);
        Assert.assertEquals((Object)testUri, (Object)r.getLocation());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{session});
    }

    @Test
    public void validateNoParams() {
        try {
            Session session = (Session)Mockito.mock(Session.class);
            TestAuthenticator a = new TestAuthenticator(session);
            Authenticator config = new Authenticator();
            a.validate(config);
            config.setConfiguration(new HashMap());
            a.validate(config);
            config.getConfiguration().put("foo", "bar");
            a.validate(config);
        }
        catch (Exception e) {
            Assert.assertNull((Object)e);
        }
    }

    @Test(expected=KangarooException.class)
    public void validateThrowsWithParams() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("invalid", "unimportant_value");
        Session session = (Session)Mockito.mock(Session.class);
        TestAuthenticator a = new TestAuthenticator(session);
        Authenticator config = new Authenticator();
        config.setConfiguration(hashMap);
        a.validate(config);
    }

    @Test
    public void authenticateNoTestUser() {
        TestAuthenticator a = new TestAuthenticator(this.getSession());
        Authenticator config = context.getAuthenticator();
        MultivaluedHashMap params = new MultivaluedHashMap();
        UserIdentity i = a.authenticate(config, (MultivaluedMap)params, null);
        Assert.assertNotNull((Object)i);
        Assert.assertNotNull((Object)i.getId());
        Assert.assertTrue((boolean)this.getSession().contains((Object)i));
        Assert.assertEquals((Object)"dev_user", (Object)i.getRemoteId());
    }

    @Test
    public void authenticateTestUserWithMatchingRoles() {
        Assert.assertNotNull((Object)context.getApplication().getDefaultRole());
        TestAuthenticator a = new TestAuthenticator(this.getSession());
        Authenticator config = context.getAuthenticator();
        MultivaluedHashMap params = new MultivaluedHashMap();
        UserIdentity i = a.authenticate(config, (MultivaluedMap)params, null);
        Assert.assertNotNull((Object)i);
        Assert.assertNotNull((Object)i.getId());
        Assert.assertTrue((boolean)this.getSession().contains((Object)i));
        Assert.assertEquals((Object)"dev_user", (Object)i.getRemoteId());
        Assert.assertEquals((Object)context.getApplication().getDefaultRole(), (Object)i.getUser().getRole());
    }

    @Test
    public void authenticateWithTestUser() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().user().identity("dev_user").build();
        UserIdentity persistedIdentity = testContext.getUserIdentity();
        TestAuthenticator a = new TestAuthenticator(this.getSession());
        Authenticator config = testContext.getAuthenticator();
        MultivaluedHashMap params = new MultivaluedHashMap();
        UserIdentity i = a.authenticate(config, (MultivaluedMap)params, null);
        Assert.assertEquals((Object)persistedIdentity, (Object)i);
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).client(ClientType.AuthorizationGrant).role("not_test_role").authenticator(AuthenticatorType.Test).build();
            }
        };
    }
}

