/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.password;

import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.password.PasswordAuthenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.test.TestAuthenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

public final class PasswordAuthenticatorTest
extends DatabaseTest {
    private static ApplicationBuilder.ApplicationContext context;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    @Test
    public void testDelegate() throws Exception {
        PasswordAuthenticator a = new PasswordAuthenticator(this.getSession());
        Authenticator config = new Authenticator();
        URI callback = UriBuilder.fromPath((String)"http://example.com").build(new Object[0]);
        Response r = a.delegate(config, callback);
        Assert.assertNull((Object)r);
    }

    @Test
    public void validateNoParams() {
        try {
            Session session = (Session)Mockito.mock(Session.class);
            TestAuthenticator a = new TestAuthenticator(session);
            Authenticator config = new Authenticator();
            a.validate(config);
            config.setConfiguration(new HashMap());
            a.validate(config);
        }
        catch (Exception e) {
            Assert.assertNull((Object)e);
        }
    }

    @Test(expected=KangarooException.class)
    public void validateThrowsWithParams() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("foo", "bar");
        Session session = (Session)Mockito.mock(Session.class);
        PasswordAuthenticator a = new PasswordAuthenticator(session);
        Authenticator config = new Authenticator();
        config.setConfiguration(hashMap);
        a.validate(config);
        a.validate(null);
    }

    @Test
    public void testAuthenticateValid() throws Exception {
        PasswordAuthenticator a = new PasswordAuthenticator(this.getSession());
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.add((Object)"username", (Object)"login");
        params.add((Object)"password", (Object)"password");
        UserIdentity i = a.authenticate(context.getAuthenticator(), (MultivaluedMap)params, null);
        Assert.assertEquals((Object)"login", (Object)i.getRemoteId());
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testAuthenticateNullConfig() throws Exception {
        PasswordAuthenticator a = new PasswordAuthenticator(this.getSession());
        MultivaluedHashMap params = new MultivaluedHashMap();
        a.authenticate(null, (MultivaluedMap)params, null);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testAuthenticateNullParams() throws Exception {
        PasswordAuthenticator a = new PasswordAuthenticator(this.getSession());
        Authenticator config = new Authenticator();
        a.authenticate(config, null, null);
    }

    @Test
    public void testAuthenticateNoIdentity() throws Exception {
        PasswordAuthenticator a = new PasswordAuthenticator(this.getSession());
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.add((Object)"username", (Object)"wrongIdentity");
        params.add((Object)"password", (Object)"password");
        UserIdentity i = a.authenticate(context.getAuthenticator(), (MultivaluedMap)params, null);
        Assert.assertNull((Object)i);
    }

    @Test
    public void testAuthenticateWrongPassword() throws Exception {
        PasswordAuthenticator a = new PasswordAuthenticator(this.getSession());
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.add((Object)"username", (Object)"login");
        params.add((Object)"password", (Object)"wrongpassword");
        UserIdentity i = a.authenticate(context.getAuthenticator(), (MultivaluedMap)params, null);
        Assert.assertNull((Object)i);
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).client(ClientType.OwnerCredentials).authenticator(AuthenticatorType.Password).user().login("login", "password").build();
            }
        };
    }
}

