/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.oauth2;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import junit.framework.TestCase;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.exception.MisconfiguredAuthenticatorException;
import net.krotscheck.kangaroo.authz.common.authenticator.exception.ThirdPartyErrorException;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.AbstractOAuth2Authenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2IdPToken;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2User;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class AbstractOAuth2AuthenticatorTest
extends DatabaseTest {
    private static ApplicationBuilder.ApplicationContext context;
    private static ApplicationBuilder.ApplicationContext mirrorContext;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;
    private TestOAuth2Authenticator authenticator;
    private Authenticator config;
    private URI validCallback = URI.create("http://example.com/authorize/callback?state=state");
    private Client client;
    private WebTarget webTarget;
    private Invocation.Builder builder;
    private Response postResponse;
    private Response getResponse;

    @Before
    public void setup() {
        this.authenticator = new TestOAuth2Authenticator();
    }

    @Before
    public void bootstrap() {
        this.getSession().beginTransaction();
        this.config = context.getAuthenticator();
        this.client = (Client)Mockito.mock(Client.class);
        this.webTarget = (WebTarget)Mockito.mock(WebTarget.class);
        this.builder = (Invocation.Builder)Mockito.mock(Invocation.Builder.class);
        this.getResponse = (Response)Mockito.mock(Response.class);
        this.postResponse = (Response)Mockito.mock(Response.class);
        ((Client)Mockito.doReturn((Object)this.webTarget).when((Object)this.client)).target(ArgumentMatchers.anyString());
        ((WebTarget)Mockito.doReturn((Object)this.builder).when((Object)this.webTarget)).request();
        ((Invocation.Builder)Mockito.doReturn((Object)this.builder).when((Object)this.builder)).header((String)ArgumentMatchers.any(), ArgumentMatchers.any());
        ((Invocation.Builder)Mockito.doReturn((Object)this.getResponse).when((Object)this.builder)).get();
        ((Invocation.Builder)Mockito.doReturn((Object)this.postResponse).when((Object)this.builder)).post((Entity)ArgumentMatchers.any());
        ((Response)Mockito.doReturn((Object)Response.Status.OK).when((Object)this.getResponse)).getStatusInfo();
        ((Response)Mockito.doReturn((Object)Response.Status.OK).when((Object)this.postResponse)).getStatusInfo();
        this.authenticator = new TestOAuth2Authenticator();
        this.authenticator.setClient(this.client);
        this.authenticator.setSession(this.getSession());
    }

    @After
    public void cleanup() {
        Transaction t = this.getSession().getTransaction();
        if (t.isActive()) {
            t.commit();
        }
    }

    @Test
    public void testGetSetSession() {
        Assert.assertNotNull((Object)this.authenticator.getSession());
        this.authenticator.setSession(null);
        TestCase.assertNull((Object)this.authenticator.getSession());
        this.authenticator.setSession(this.getSession());
        Assert.assertNotNull((Object)this.authenticator.getSession());
    }

    @Test
    public void testGetSetClient() {
        Assert.assertNotNull((Object)this.authenticator.getClient());
        this.authenticator.setClient(null);
        TestCase.assertNull((Object)this.authenticator.getClient());
        this.authenticator.setClient(this.client);
        Assert.assertNotNull((Object)this.authenticator.getClient());
    }

    @Test
    public void testDelegate() {
        Response r = this.authenticator.delegate(this.config, this.validCallback);
        Assert.assertEquals((long)302L, (long)r.getStatus());
        String location = r.getHeaderString("Location");
        URI redirect = URI.create(location);
        Assert.assertEquals((Object)"example.com", (Object)redirect.getHost());
        Assert.assertEquals((Object)"/authorize", (Object)redirect.getPath());
        Assert.assertEquals((Object)"http", (Object)redirect.getScheme());
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)redirect);
        Assert.assertEquals((Object)"id", (Object)params.getFirst((Object)"client_id"));
        Assert.assertEquals((Object)"test scope", (Object)params.getFirst((Object)"scope"));
        Assert.assertEquals((Object)"code", (Object)params.getFirst((Object)"response_type"));
        Assert.assertEquals((Object)"http://example.com/authorize/callback", (Object)params.getFirst((Object)"redirect_uri"));
        Assert.assertEquals((Object)"state", (Object)params.getFirst((Object)"state"));
    }

    @Test(expected=MisconfiguredAuthenticatorException.class)
    public void testDelegateInvalidConfiguration() {
        Authenticator testConfig = new Authenticator();
        this.authenticator.delegate(testConfig, this.validCallback);
    }

    @Test(expected=RFC6749.ServerErrorException.class)
    public void testDelegateNoCallback() {
        this.authenticator.delegate(this.config, null);
    }

    @Test(expected=RFC6749.ServerErrorException.class)
    public void testDelegateNoCallbackState() {
        URI callback = URI.create("http://example.com/authorize/callback");
        this.authenticator.delegate(this.config, callback);
    }

    @Test
    public void testAuthenticate() {
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)result).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        OAuth2User testUser = new OAuth2User();
        testUser.setId(RandomStringUtils.randomAlphanumeric((int)10));
        testUser.getClaims().put("name", "Some Random Name");
        testUser.getClaims().put("email", "lol@example.com");
        ((Response)Mockito.doReturn((Object)testUser).when((Object)this.getResponse)).readEntity(OAuth2User.class);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        UserIdentity identity = this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
        Assert.assertEquals((Object)testUser.getId(), (Object)identity.getRemoteId());
        Assert.assertEquals((Object)"Some Random Name", testUser.getClaims().get("name"));
        Assert.assertEquals((Object)"lol@example.com", testUser.getClaims().get("email"));
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testAuthenticateWithRemoteError() {
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"error", (Object)"test");
        params.putSingle((Object)"error_description", (Object)"description");
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test(expected=RFC6749.InvalidRequestException.class)
    public void testAuthenticateWithNoAuthCode() {
        MultivaluedStringMap params = new MultivaluedStringMap();
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testAuthenticateWithTokenError() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("error", "test");
        response.put("error_description", "description");
        ((Response)Mockito.doReturn((Object)Response.Status.BAD_REQUEST).when((Object)this.postResponse)).getStatusInfo();
        ((Response)Mockito.doReturn(response).when((Object)this.postResponse)).readEntity(AbstractOAuth2Authenticator.MAP_TYPE);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testAuthenticateWithUnparseableToken() {
        ((Response)Mockito.doThrow(ProcessingException.class).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testAuthenticateWithNoTokenResponse() {
        OAuth2IdPToken result = new OAuth2IdPToken();
        ((Response)Mockito.doReturn((Object)result).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test(expected=Exception.class)
    public void testAuthenticateErrorOnTokenClose() {
        OAuth2IdPToken idPToken = new OAuth2IdPToken();
        idPToken.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)idPToken).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        ((Response)Mockito.doThrow(Exception.class).when((Object)this.postResponse)).close();
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testAuthenticateWithUserError() {
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)result).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("error", "test");
        response.put("error_description", "description");
        ((Response)Mockito.doReturn((Object)Response.Status.BAD_REQUEST).when((Object)this.getResponse)).getStatusInfo();
        ((Response)Mockito.doReturn(response).when((Object)this.getResponse)).readEntity(AbstractOAuth2Authenticator.MAP_TYPE);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testAuthenticateWithUnparseableUser() {
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)result).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        ((Response)Mockito.doThrow(ProcessingException.class).when((Object)this.getResponse)).readEntity(OAuth2User.class);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testAuthenticateWithNoUserResponse() {
        OAuth2IdPToken idPToken = new OAuth2IdPToken();
        idPToken.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)idPToken).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        OAuth2User result = new OAuth2User();
        ((Response)Mockito.doReturn((Object)result).when((Object)this.getResponse)).readEntity(OAuth2User.class);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test(expected=Exception.class)
    public void testAuthenticateErrorOnClose() {
        OAuth2IdPToken idPToken = new OAuth2IdPToken();
        idPToken.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)idPToken).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        OAuth2User testUser = new OAuth2User();
        testUser.setId(RandomStringUtils.randomAlphanumeric((int)10));
        testUser.getClaims().put("name", "Some Random Name");
        testUser.getClaims().put("email", "lol@example.com");
        ((Response)Mockito.doReturn((Object)testUser).when((Object)this.getResponse)).readEntity(OAuth2User.class);
        ((Response)Mockito.doThrow(Exception.class).when((Object)this.getResponse)).close();
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
    }

    @Test
    public void testAuthenticateCreateNewUser() {
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)result).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        OAuth2User testUser = new OAuth2User();
        testUser.setId(RandomStringUtils.randomAlphanumeric((int)10));
        testUser.getClaims().put("name", "Some Random Name");
        testUser.getClaims().put("email", "lol@example.com");
        ((Response)Mockito.doReturn((Object)testUser).when((Object)this.getResponse)).readEntity(OAuth2User.class);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        UserIdentity identity = this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
        this.getSession().getTransaction().commit();
        this.getSession().refresh((Object)identity.getUser());
        Assert.assertEquals((long)1L, (long)identity.getUser().getIdentities().size());
        Assert.assertEquals((Object)"lol@example.com", identity.getClaims().get("email"));
        Assert.assertEquals((Object)"Some Random Name", identity.getClaims().get("name"));
    }

    @Test
    public void testAuthenticateUpdateExistingUser() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().user().identity("remote_identity").build();
        Assert.assertEquals((long)0L, (long)testContext.getUserIdentity().getClaims().size());
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)result).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        OAuth2User testUser = new OAuth2User();
        testUser.setId("remote_identity");
        testUser.getClaims().put("name", "Some Random Name");
        testUser.getClaims().put("email", "lol@example.com");
        ((Response)Mockito.doReturn((Object)testUser).when((Object)this.getResponse)).readEntity(OAuth2User.class);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        UserIdentity identity = this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
        Assert.assertEquals((Object)identity, (Object)testContext.getUserIdentity());
        Assert.assertEquals((Object)"lol@example.com", identity.getClaims().get("email"));
        Assert.assertEquals((Object)"Some Random Name", identity.getClaims().get("name"));
    }

    @Test
    public void testAuthenticateNewUserNoConflict() {
        String remoteIdentity = RandomStringUtils.randomAlphabetic((int)10);
        ApplicationBuilder.ApplicationContext testContext = mirrorContext.getBuilder().user().identity(remoteIdentity).claim("email", "email@example.com").build();
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)result).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        OAuth2User testUser = new OAuth2User();
        testUser.setId(remoteIdentity);
        testUser.getClaims().put("name", "Some Random Name");
        testUser.getClaims().put("email", "lol@example.com");
        ((Response)Mockito.doReturn((Object)testUser).when((Object)this.getResponse)).readEntity(OAuth2User.class);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        UserIdentity identity = this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
        this.getSession().getTransaction().commit();
        this.getSession().refresh((Object)identity.getUser());
        Assert.assertEquals((Object)remoteIdentity, (Object)identity.getRemoteId());
        Assert.assertEquals((Object)"lol@example.com", identity.getClaims().get("email"));
        Assert.assertEquals((Object)"Some Random Name", identity.getClaims().get("name"));
        Assert.assertNotEquals((Object)identity, (Object)testContext.getUserIdentity());
        this.getSession().refresh((Object)testContext.getUserIdentity());
        this.getSession().refresh((Object)identity);
        Assert.assertNotEquals(testContext.getUserIdentity().getClaims().get("email"), identity.getClaims().get("email"));
    }

    @Test
    public void testAuthenticateUpdateUserNoConflict() {
        String remoteIdentity = RandomStringUtils.randomAlphabetic((int)10);
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().user().identity(remoteIdentity).claim("email", "email@example.com").build();
        ApplicationBuilder.ApplicationContext testMirrorContext = mirrorContext.getBuilder().user().identity(remoteIdentity).claim("email", "email@example.com").build();
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        ((Response)Mockito.doReturn((Object)result).when((Object)this.postResponse)).readEntity(OAuth2IdPToken.class);
        OAuth2User testUser = new OAuth2User();
        testUser.setId(remoteIdentity);
        testUser.getClaims().put("name", "Some Random Name");
        testUser.getClaims().put("email", "lol@example.com");
        ((Response)Mockito.doReturn((Object)testUser).when((Object)this.getResponse)).readEntity(OAuth2User.class);
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        UserIdentity identity = this.authenticator.authenticate(this.config, (MultivaluedMap)params, this.validCallback);
        this.getSession().getTransaction().commit();
        this.getSession().refresh((Object)identity.getUser());
        this.getSession().refresh((Object)testContext.getUserIdentity());
        this.getSession().refresh((Object)testMirrorContext.getUserIdentity());
        Assert.assertEquals((Object)remoteIdentity, (Object)identity.getRemoteId());
        Assert.assertEquals((Object)"lol@example.com", identity.getClaims().get("email"));
        Assert.assertEquals((Object)"Some Random Name", identity.getClaims().get("name"));
        Assert.assertNotEquals((Object)identity, (Object)testMirrorContext.getUserIdentity());
        Assert.assertEquals((Object)"email@example.com", testMirrorContext.getUserIdentity().getClaims().get("email"));
    }

    @Test(expected=MisconfiguredAuthenticatorException.class)
    public void testValidateNullInput() throws Exception {
        this.authenticator.validate(null);
    }

    @Test(expected=MisconfiguredAuthenticatorException.class)
    public void testValidateNullConfig() throws Exception {
        Authenticator config = new Authenticator();
        config.setConfiguration(null);
        this.authenticator.validate(config);
    }

    @Test(expected=MisconfiguredAuthenticatorException.class)
    public void testValidateEmptyConfig() throws Exception {
        Authenticator config = new Authenticator();
        this.authenticator.validate(config);
    }

    @Test(expected=MisconfiguredAuthenticatorException.class)
    public void testValidateNoAppId() throws Exception {
        Authenticator config = new Authenticator();
        config.getConfiguration().put("client_secret", "foo");
        this.authenticator.validate(config);
    }

    @Test(expected=MisconfiguredAuthenticatorException.class)
    public void testValidateNoAppSecret() throws Exception {
        Authenticator config = new Authenticator();
        config.getConfiguration().put("client_id", "foo");
        this.authenticator.validate(config);
    }

    @Test
    public void testValidate() throws Exception {
        Authenticator config = new Authenticator();
        config.getConfiguration().put("client_id", "foo");
        config.getConfiguration().put("client_secret", "bar");
        this.authenticator.validate(config);
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                HashMap<String, String> fbConfig = new HashMap<String, String>();
                fbConfig.put("client_id", "id");
                fbConfig.put("client_secret", "secret");
                context = ApplicationBuilder.newApplication(session).client(ClientType.AuthorizationGrant).role("some_role").authenticator(AuthenticatorType.Test, fbConfig).build();
                mirrorContext = ApplicationBuilder.newApplication(session).client(ClientType.AuthorizationGrant).role("some_role").authenticator(AuthenticatorType.Test, fbConfig).build();
            }
        };
    }

    private static final class TestOAuth2Authenticator
    extends AbstractOAuth2Authenticator {
        private TestOAuth2Authenticator() {
        }

        protected String getAuthEndpoint() {
            return "http://example.com/authorize";
        }

        protected String getTokenEndpoint() {
            return "http://example.com/token";
        }

        protected String getScopes() {
            return "test scope";
        }

        protected OAuth2User loadUserIdentity(OAuth2IdPToken token) {
            try (Response r = this.getClient().target("http://example.com/user").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((String)token.getAccessToken())).get();){
                if (r.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                    OAuth2User oAuth2User = (OAuth2User)r.readEntity(OAuth2User.class);
                    return oAuth2User;
                }
                try {
                    Map params = (Map)r.readEntity(MAP_TYPE);
                    throw new ThirdPartyErrorException(params);
                }
                catch (ProcessingException e) {
                    throw new ThirdPartyErrorException();
                }
            }
        }
    }
}

