/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.google;

import junit.framework.TestCase;
import net.krotscheck.kangaroo.authz.common.authenticator.google.GoogleUserEntity;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2User;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;

public final class GoogleUserEntityTest {
    @Test
    public void getSetName() {
        String randomValue = RandomStringUtils.randomAlphabetic((int)30);
        GoogleUserEntity token = new GoogleUserEntity();
        Assert.assertNull((Object)token.getName());
        token.setName(randomValue);
        Assert.assertEquals((Object)randomValue, (Object)token.getName());
    }

    @Test
    public void getSetId() {
        String randomValue = RandomStringUtils.randomAlphabetic((int)30);
        GoogleUserEntity token = new GoogleUserEntity();
        Assert.assertNull((Object)token.getId());
        token.setId(randomValue);
        Assert.assertEquals((Object)randomValue, (Object)token.getId());
    }

    @Test
    public void getSetEmail() {
        String randomValue = RandomStringUtils.randomAlphabetic((int)30);
        GoogleUserEntity token = new GoogleUserEntity();
        Assert.assertNull((Object)token.getEmail());
        token.setEmail(randomValue);
        Assert.assertEquals((Object)randomValue, (Object)token.getEmail());
    }

    @Test
    public void getSetVerifiedEmail() {
        GoogleUserEntity token = new GoogleUserEntity();
        TestCase.assertFalse((boolean)token.isVerifiedEmail());
        token.setVerifiedEmail(Boolean.valueOf(true));
        Assert.assertTrue((boolean)token.isVerifiedEmail());
    }

    @Test
    public void getSetFamilyName() {
        String randomValue = RandomStringUtils.randomAlphabetic((int)30);
        GoogleUserEntity token = new GoogleUserEntity();
        Assert.assertNull((Object)token.getFamilyName());
        token.setFamilyName(randomValue);
        Assert.assertEquals((Object)randomValue, (Object)token.getFamilyName());
    }

    @Test
    public void getSetLink() {
        String randomValue = RandomStringUtils.randomAlphabetic((int)30);
        GoogleUserEntity token = new GoogleUserEntity();
        Assert.assertNull((Object)token.getLink());
        token.setLink(randomValue);
        Assert.assertEquals((Object)randomValue, (Object)token.getLink());
    }

    @Test
    public void getSetPicture() {
        String randomValue = RandomStringUtils.randomAlphabetic((int)30);
        GoogleUserEntity token = new GoogleUserEntity();
        Assert.assertNull((Object)token.getPicture());
        token.setPicture(randomValue);
        Assert.assertEquals((Object)randomValue, (Object)token.getPicture());
    }

    @Test
    public void getSetLocale() {
        String randomValue = RandomStringUtils.randomAlphabetic((int)30);
        GoogleUserEntity token = new GoogleUserEntity();
        Assert.assertNull((Object)token.getLocale());
        token.setLocale(randomValue);
        Assert.assertEquals((Object)randomValue, (Object)token.getLocale());
    }

    @Test
    public void testAsGenericUser() {
        GoogleUserEntity token = new GoogleUserEntity();
        token.setId(RandomStringUtils.randomAlphabetic((int)30));
        token.setName(RandomStringUtils.randomAlphabetic((int)30));
        token.setVerifiedEmail(Boolean.valueOf(true));
        token.setFamilyName(RandomStringUtils.randomAlphabetic((int)30));
        token.setLink(RandomStringUtils.randomAlphabetic((int)30));
        token.setPicture(RandomStringUtils.randomAlphabetic((int)30));
        token.setLocale(RandomStringUtils.randomAlphabetic((int)30));
        OAuth2User user = token.asGenericUser();
        Assert.assertEquals((Object)token.getId(), (Object)user.getId());
        Assert.assertEquals((Object)token.getName(), user.getClaims().get("name"));
        Assert.assertEquals((Object)token.isVerifiedEmail().toString(), user.getClaims().get("verified_email"));
        Assert.assertEquals((Object)token.getFamilyName(), user.getClaims().get("family_name"));
        Assert.assertEquals((Object)token.getLink(), user.getClaims().get("link"));
        Assert.assertEquals((Object)token.getPicture(), user.getClaims().get("picture"));
        Assert.assertEquals((Object)token.getLocale(), user.getClaims().get("locale"));
    }
}

