/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.facebook;

import java.util.HashMap;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.exception.ThirdPartyErrorException;
import net.krotscheck.kangaroo.authz.common.authenticator.facebook.FacebookAuthenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.facebook.FacebookUserEntity;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2IdPToken;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2User;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import org.apache.commons.lang3.RandomStringUtils;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class FacebookAuthenticatorTest
extends DatabaseTest {
    private static ApplicationBuilder.ApplicationContext context;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;
    private Client client;
    private WebTarget webTarget;
    private Invocation.Builder builder;
    private Response getResponse;
    private FacebookAuthenticator fbAuth;

    @Before
    public void bootstrap() {
        this.getSession().beginTransaction();
        this.client = (Client)Mockito.mock(Client.class);
        this.webTarget = (WebTarget)Mockito.mock(WebTarget.class);
        this.builder = (Invocation.Builder)Mockito.mock(Invocation.Builder.class);
        this.getResponse = (Response)Mockito.mock(Response.class);
        ((Client)Mockito.doReturn((Object)this.webTarget).when((Object)this.client)).target(ArgumentMatchers.anyString());
        ((WebTarget)Mockito.doReturn((Object)this.builder).when((Object)this.webTarget)).request();
        ((Invocation.Builder)Mockito.doReturn((Object)this.builder).when((Object)this.builder)).header((String)ArgumentMatchers.any(), ArgumentMatchers.any());
        ((Invocation.Builder)Mockito.doReturn((Object)this.getResponse).when((Object)this.builder)).get();
        ((Response)Mockito.doReturn((Object)Response.Status.OK).when((Object)this.getResponse)).getStatusInfo();
        this.fbAuth = new FacebookAuthenticator();
        this.fbAuth.setClient(this.client);
        this.fbAuth.setSession(this.getSession());
    }

    @After
    public void cleanup() {
        Transaction t = this.getSession().getTransaction();
        if (t.isActive()) {
            t.commit();
        }
    }

    @Test
    public void testStaticAccessors() {
        Assert.assertEquals((Object)"https://www.facebook.com/v2.10/dialog/oauth", (Object)this.fbAuth.getAuthEndpoint());
        Assert.assertEquals((Object)"https://graph.facebook.com/v2.10/oauth/access_token", (Object)this.fbAuth.getTokenEndpoint());
        Assert.assertEquals((Object)"public_profile,email", (Object)this.fbAuth.getScopes());
    }

    @Test
    public void testLoadUser() {
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        FacebookUserEntity user = new FacebookUserEntity();
        user.setId("test_id");
        user.setName("test name");
        ((Response)Mockito.doReturn((Object)user).when((Object)this.getResponse)).readEntity(FacebookUserEntity.class);
        OAuth2User returnedUser = this.fbAuth.loadUserIdentity(result);
        Assert.assertEquals((Object)returnedUser.getId(), (Object)user.getId());
        Assert.assertEquals((Object)"test name", returnedUser.getClaims().get("name"));
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testLoadUserWithRemoteError() {
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("error", "test");
        response.put("error_description", "description");
        ((Response)Mockito.doReturn((Object)Response.Status.BAD_REQUEST).when((Object)this.getResponse)).getStatusInfo();
        ((Response)Mockito.doReturn(response).when((Object)this.getResponse)).readEntity(FacebookAuthenticator.MAP_TYPE);
        this.fbAuth.loadUserIdentity(result);
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testLoadUserUnparseable() {
        OAuth2IdPToken result = new OAuth2IdPToken();
        result.setAccessToken("facebook_access_token");
        ((Response)Mockito.doThrow(ProcessingException.class).when((Object)this.getResponse)).readEntity(FacebookUserEntity.class);
        this.fbAuth.loadUserIdentity(result);
    }

    @Test(expected=ThirdPartyErrorException.class)
    public void testLoadUserNoResponse() {
        OAuth2IdPToken idPToken = new OAuth2IdPToken();
        idPToken.setAccessToken("facebook_access_token");
        FacebookUserEntity result = new FacebookUserEntity();
        ((Response)Mockito.doReturn((Object)result).when((Object)this.getResponse)).readEntity(FacebookUserEntity.class);
        this.fbAuth.loadUserIdentity(idPToken);
    }

    @Test(expected=Exception.class)
    public void testLoadUserErrorOnClose() {
        OAuth2IdPToken idPToken = new OAuth2IdPToken();
        idPToken.setAccessToken("facebook_access_token");
        FacebookUserEntity testUser = new FacebookUserEntity();
        testUser.setId(RandomStringUtils.randomAlphanumeric((int)10));
        testUser.setName("Some Random Name");
        testUser.setEmail("lol@example.com");
        ((Response)Mockito.doReturn((Object)testUser).when((Object)this.getResponse)).readEntity(FacebookUserEntity.class);
        ((Response)Mockito.doThrow(Exception.class).when((Object)this.getResponse)).close();
        MultivaluedStringMap params = new MultivaluedStringMap();
        params.putSingle((Object)"code", (Object)"valid_code");
        this.fbAuth.loadUserIdentity(idPToken);
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                HashMap<String, String> fbConfig = new HashMap<String, String>();
                fbConfig.put("client_id", "id");
                fbConfig.put("client_secret", "secret");
                context = ApplicationBuilder.newApplication(session).client(ClientType.AuthorizationGrant).role("some_role").authenticator(AuthenticatorType.Facebook, fbConfig).build();
            }
        };
    }
}

