/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.common.authenticator.AbstractBrowserLoginTest;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.TestConfig;
import net.krotscheck.kangaroo.test.runner.SingleInstanceTestRunner;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

@RunWith(value=SingleInstanceTestRunner.class)
public final class GoogleFullAuthFlowTest
extends AbstractBrowserLoginTest {
    private void googleLoginV1() {
        ChromeDriver d = SELENIUM.getDriver();
        By emailInput = By.id((String)"identifierId");
        By nextButton = By.id((String)"identifierNext");
        By passInput = By.cssSelector((String)"div#password input[type='password']");
        By passNext = By.id((String)"passwordNext");
        d.findElement(emailInput).clear();
        d.findElement(emailInput).sendKeys(new CharSequence[]{TestConfig.getGoogleAccountId()});
        d.findElement(nextButton).click();
        SELENIUM.screenshot();
        new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.elementToBeClickable((By)passInput));
        d.findElement(passInput).clear();
        d.findElement(passInput).sendKeys(new CharSequence[]{TestConfig.getGoogleAccountSecret()});
        d.findElement(passNext).click();
        this.postLoginChecks();
    }

    private void googleLoginV2() {
        ChromeDriver d = SELENIUM.getDriver();
        SELENIUM.screenshot();
        By emailInput = By.id((String)"Email");
        By nextButton = By.id((String)"next");
        By passInput = By.id((String)"Passwd");
        By signinButton = By.id((String)"signIn");
        d.findElement(emailInput).clear();
        d.findElement(emailInput).sendKeys(new CharSequence[]{TestConfig.getGoogleAccountId()});
        d.findElement(nextButton).click();
        new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.elementToBeClickable((By)passInput));
        d.findElement(passInput).clear();
        d.findElement(passInput).sendKeys(new CharSequence[]{TestConfig.getGoogleAccountSecret()});
        d.findElement(signinButton).click();
        this.postLoginChecks();
    }

    private void postLoginChecks() {
        ChromeDriver d = SELENIUM.getDriver();
        SELENIUM.screenshot();
        new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.or((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.urlContains((String)"https://myaccount.google.com"), ExpectedConditions.urlContains((String)"https://accounts.google.com/signin/oauth/oauthchooseaccount"), ExpectedConditions.urlContains((String)"https://accounts.google.com/signin/v2/challenge/selection")}));
        if (d.getCurrentUrl().contains("https://accounts.google.com/signin/v2/challenge/selection")) {
            SELENIUM.screenshot();
            d.findElement(By.cssSelector((String)"[data-challengetype=16]")).click();
            ((WebElement)new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"knowledgeLoginLocationInput")))).sendKeys(new CharSequence[]{"Bellevue, WA"});
            d.findElement(By.id((String)"next")).click();
            new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.or((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.urlContains((String)"https://myaccount.google.com")}));
        }
    }

    @Before
    public void googleLogin() {
        ChromeDriver d = SELENIUM.getDriver();
        d.get("https://accounts.google.com/ServiceLogin");
        SELENIUM.screenshot();
        new WebDriverWait((WebDriver)d, 10L).until((Function)ExpectedConditions.or((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.elementToBeClickable((By)By.id((String)"identifierId")), ExpectedConditions.elementToBeClickable((By)By.id((String)"Email"))}));
        if (d.findElements(By.id((String)"Email")).size() > 0) {
            this.googleLoginV2();
        } else {
            this.googleLoginV1();
        }
    }

    @After
    public void googleLogout() {
        ChromeDriver d = SELENIUM.getDriver();
        d.get("https://accounts.google.com/Logout");
        SELENIUM.screenshot();
        new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.urlContains((String)"https://accounts.google.com/"));
        SELENIUM.screenshot();
    }

    @Test
    public void testNewLogin() {
        String testState = RandomStringUtils.randomAlphanumeric((int)20);
        URI requestUri = UriBuilder.fromUri((URI)this.getBaseUri()).path("/authorize").queryParam("authenticator", new Object[]{AuthenticatorType.Google}).queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)GoogleFullAuthFlowTest.getContext().getClient().getId())}).queryParam("scope", new Object[]{"debug"}).queryParam("state", new Object[]{testState}).build(new Object[0]);
        ChromeDriver d = SELENIUM.getDriver();
        d.get(requestUri.toString());
        SELENIUM.screenshot();
        new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.or((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.urlContains((String)"https://accounts.google.com/signin/oauth/oauthchooseaccount"), ExpectedConditions.elementToBeClickable((By)By.id((String)"submit_approve_access"))}));
        SELENIUM.screenshot();
        if (d.getCurrentUrl().contains("https://accounts.google.com/signin/oauth/oauthchooseaccount")) {
            d.findElement(By.cssSelector((String)"[data-profileindex=\"0\"]")).click();
            SELENIUM.screenshot();
        } else {
            d.findElement(By.id((String)"submit_approve_access")).click();
            SELENIUM.screenshot();
        }
        new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.urlContains((String)"www.example.com"));
        SELENIUM.screenshot();
        String url = d.getCurrentUrl();
        URI uri = URI.create(url);
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)uri);
        BigInteger code = IdUtil.fromString((String)((String)params.getFirst((Object)"code")));
        Assert.assertEquals((Object)testState, (Object)params.getFirst((Object)"state"));
        OAuthToken authToken = (OAuthToken)this.getSession().get(OAuthToken.class, (Serializable)code);
        Assert.assertEquals((Object)authToken.getClient().getId(), (Object)GoogleFullAuthFlowTest.getContext().getClient().getId());
        Assert.assertEquals((Object)AuthenticatorType.Google, (Object)authToken.getIdentity().getType());
        Assert.assertEquals((Object)OAuthTokenType.Authorization, (Object)authToken.getTokenType());
    }
}

