/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.common.authenticator.AbstractBrowserLoginTest;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.rule.FacebookTestUser;
import net.krotscheck.kangaroo.test.runner.SingleInstanceTestRunner;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

@RunWith(value=SingleInstanceTestRunner.class)
public final class FacebookFullAuthFlowTest
extends AbstractBrowserLoginTest {
    @ClassRule
    public static final FacebookTestUser FB_USER = new FacebookTestUser();

    @Before
    public void facebookLogin() {
        ChromeDriver d = SELENIUM.getDriver();
        d.get("https://www.facebook.com/");
        new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.and((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.elementToBeClickable((By)By.id((String)"loginbutton")), ExpectedConditions.elementToBeClickable((By)By.id((String)"email")), ExpectedConditions.elementToBeClickable((By)By.id((String)"pass"))}));
        d.findElement(By.id((String)"email")).clear();
        d.findElement(By.id((String)"email")).sendKeys(new CharSequence[]{FB_USER.getEmail()});
        d.findElement(By.id((String)"pass")).clear();
        d.findElement(By.id((String)"pass")).sendKeys(new CharSequence[]{FB_USER.getPassword()});
        d.findElement(By.id((String)"loginbutton")).click();
        new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"pagelet_welcome")));
    }

    @After
    public void facebookLogout() {
        ChromeDriver d = SELENIUM.getDriver();
        d.get("https://www.facebook.com/");
        ((WebElement)new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)"a#pageLoginAnchor")))).click();
        ((WebElement)new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.presenceOfElementLocated((By)By.partialLinkText((String)"Log Out")))).click();
        ((WebElement)new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"loginbutton")))).click();
    }

    @Test
    public void testNewLogin() {
        String testState = RandomStringUtils.randomAlphanumeric((int)20);
        URI requestUri = UriBuilder.fromUri((URI)this.getBaseUri()).path("/authorize").queryParam("authenticator", new Object[]{AuthenticatorType.Facebook}).queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{IdUtil.toString((BigInteger)FacebookFullAuthFlowTest.getContext().getClient().getId())}).queryParam("scope", new Object[]{"debug"}).queryParam("state", new Object[]{testState}).build(new Object[0]);
        ChromeDriver d = SELENIUM.getDriver();
        d.get(requestUri.toString());
        new WebDriverWait((WebDriver)d, (long)TIMEOUT.intValue()).until((Function)ExpectedConditions.urlContains((String)"www.example.com"));
        String url = d.getCurrentUrl();
        URI uri = URI.create(url);
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)uri);
        BigInteger code = IdUtil.fromString((String)((String)params.getFirst((Object)"code")));
        Assert.assertEquals((Object)testState, (Object)params.getFirst((Object)"state"));
        OAuthToken authToken = (OAuthToken)this.getSession().get(OAuthToken.class, (Serializable)code);
        Assert.assertEquals((Object)authToken.getClient().getId(), (Object)FacebookFullAuthFlowTest.getContext().getClient().getId());
        Assert.assertEquals((Object)AuthenticatorType.Facebook, (Object)authToken.getIdentity().getType());
        Assert.assertEquals((Object)OAuthTokenType.Authorization, (Object)authToken.getTokenType());
    }
}

