/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator;

import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import org.junit.Assert;
import org.junit.Test;

public final class AuthenticatorTypeTest {
    @Test
    public void testIsPrivate() {
        for (AuthenticatorType type : AuthenticatorType.values()) {
            if (type.in(new AuthenticatorType[]{AuthenticatorType.Password, AuthenticatorType.Test, AuthenticatorType.Google, AuthenticatorType.Facebook}).booleanValue()) {
                Assert.assertTrue((boolean)type.isPrivate());
                continue;
            }
            Assert.assertFalse((boolean)type.isPrivate());
        }
    }

    @Test
    public void testIn() {
        Assert.assertTrue((boolean)AuthenticatorType.Password.in(new AuthenticatorType[]{AuthenticatorType.Password, AuthenticatorType.Password}));
        Assert.assertTrue((boolean)AuthenticatorType.Password.in(new AuthenticatorType[]{AuthenticatorType.Test, AuthenticatorType.Password}));
        Assert.assertTrue((boolean)AuthenticatorType.Password.in(new AuthenticatorType[]{AuthenticatorType.Password}));
        Assert.assertFalse((boolean)AuthenticatorType.Password.in(new AuthenticatorType[]{AuthenticatorType.Test, AuthenticatorType.Test}));
        Assert.assertFalse((boolean)AuthenticatorType.Password.in(new AuthenticatorType[0]));
        Assert.assertFalse((boolean)AuthenticatorType.Password.in(null));
    }

    @Test
    public void testValueOf() {
        Assert.assertEquals((Object)AuthenticatorType.Password, (Object)AuthenticatorType.valueOf((String)"Password"));
        Assert.assertEquals((Object)AuthenticatorType.Test, (Object)AuthenticatorType.valueOf((String)"Test"));
        Assert.assertEquals((Object)AuthenticatorType.Facebook, (Object)AuthenticatorType.valueOf((String)"Facebook"));
        Assert.assertEquals((Object)AuthenticatorType.Google, (Object)AuthenticatorType.valueOf((String)"Google"));
    }
}

